/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.formatter;

import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.css.core.internal.cleanup.CSSCleanupStrategy;
import org.eclipse.wst.css.core.internal.formatter.CompoundRegion;
import org.eclipse.wst.css.core.internal.formatter.DefaultCSSSourceFormatter;
import org.eclipse.wst.css.core.internal.formatter.FormatRegion;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;

public class DeclContainerFormatter
extends DefaultCSSSourceFormatter {
    DeclContainerFormatter() {
    }

    protected String decoratedSelectorRegion(CompoundRegion region, CompoundRegion prevRegion, CSSCleanupStrategy stgy) {
        String text = region.getText();
        if (DeclContainerFormatter.isFormat()) {
            return text;
        }
        String type = region.getType();
        if (type == "SELECTOR_ATTRIBUTE_NAME" || type == "SELECTOR_ATTRIBUTE_VALUE" || type == "SELECTOR_CLASS" || type == "SELECTOR_ELEMENT_NAME" || type == "SELECTOR_ID" || type == "SELECTOR_PSEUDO") {
            short selCase = stgy.getSelectorTagCase();
            if (selCase == 2) {
                return text.toUpperCase();
            }
            if (selCase == 1) {
                return text.toLowerCase();
            }
            return text;
        }
        return this.decoratedRegion(region, 0, stgy);
    }

    protected void formatPost(ICSSNode node, StringBuffer source) {
        int start;
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        int end = ((IndexedRegion)node).getEndOffset();
        int n = start = node.getLastChild() != null && ((IndexedRegion)node.getLastChild()).getEndOffset() > 0 ? ((IndexedRegion)node.getLastChild()).getEndOffset() : this.getChildInsertPos(node);
        if (end > 0 && start < end) {
            IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
            CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, new FormatRegion(start, end - start), stgy);
            int i = 0;
            while (i < regions.length) {
                this.appendDelimBefore(node, regions[i], source);
                source.append(this.decoratedRegion(regions[i], 0, stgy));
                ++i;
            }
        } else {
            String delim = this.getLineDelimiter(node);
            source.append(delim);
            source.append(this.getIndent(node));
            source.append("}");
        }
    }

    protected void formatPost(ICSSNode node, IRegion region, StringBuffer source) {
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
        CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, region, stgy);
        CompoundRegion[] outside = this.getOutsideRegions(structuredDocument, region);
        int i = 0;
        while (i < regions.length) {
            if (i != 0 || DeclContainerFormatter.needS(outside[0])) {
                this.appendDelimBefore(node, regions[i], source);
            }
            source.append(this.decoratedRegion(regions[i], 0, stgy));
            ++i;
        }
    }

    public int getChildInsertPos(ICSSNode node) {
        int n = ((IndexedRegion)node).getEndOffset();
        if (n > 0) {
            IStructuredDocumentRegion flatNode = node.getOwnerDocument().getModel().getStructuredDocument().getRegionAtCharacterOffset(n - 1);
            if (flatNode.getRegionAtCharacterOffset(n - 1).getType() == "RBRACE") {
                return n - 1;
            }
            return n;
        }
        return -1;
    }
}

