/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.text;

import org.eclipse.wst.xsd.ui.internal.util.ModelReconcileAdapter;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDModelReconcileAdapter
extends ModelReconcileAdapter {
    protected XSDSchema schema;

    public XSDModelReconcileAdapter(Document document, XSDSchema schema) {
        super(document);
        this.schema = schema;
    }

    protected void handleNodeChanged(Node node) {
        if (node instanceof Element) {
            XSDConcreteComponent concreteComponent = this.schema.getCorrespondingComponent(node);
            concreteComponent.elementChanged((Element)node);
        } else if (node instanceof Document) {
            Document document = (Document)node;
            Element schemaElement = document.getDocumentElement();
            if (schemaElement != null && schemaElement != this.schema.getElement()) {
                if (schemaElement.getLocalName().equals("schema")) {
                    this.schema.setElement(schemaElement);
                }
            } else if (schemaElement != null) {
                this.schema.elementChanged(schemaElement);
            } else if (schemaElement == null) {
                this.schema.getContents().clear();
                this.schema.getElementDeclarations().clear();
                this.schema.getTypeDefinitions().clear();
                this.schema.getAttributeDeclarations().clear();
                this.schema.getModelGroupDefinitions().clear();
                this.schema.getAttributeGroupDefinitions().clear();
                this.schema.setElement(null);
            }
        }
    }
}

