/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.xsd.ui.internal.adt.edit.IComponentDialog;
import org.eclipse.wst.xsd.ui.internal.common.commands.AddXSDComplexTypeDefinitionCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.AddXSDSimpleTypeDefinitionCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.BaseCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.SetBaseTypeAndManagerDirectivesCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.SetBaseTypeCommand;
import org.eclipse.wst.xsd.ui.internal.editor.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.XSDTypeReferenceEditManager;
import org.eclipse.wst.xsd.ui.internal.editor.search.XSDSearchListDialogDelegate;
import org.eclipse.wst.xsd.ui.internal.search.IXSDSearchConstants;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

public class XSDComplexTypeBaseTypeEditManager
extends XSDTypeReferenceEditManager {
    public XSDComplexTypeBaseTypeEditManager(IFile currentFile, XSDSchema[] schemas) {
        super(currentFile, schemas);
    }

    public ComponentSpecification[] getQuickPicks() {
        return super.getQuickPicks();
    }

    public IComponentDialog getBrowseDialog() {
        XSDSearchListDialogDelegate dialogDelegate = new XSDSearchListDialogDelegate(XSDSearchListDialogDelegate.TYPE_META_NAME, this.currentFile, this.schemas);
        return dialogDelegate;
    }

    public void modifyComponentReference(Object referencingObject, ComponentSpecification component) {
        SetBaseTypeAndManagerDirectivesCommand command;
        XSDComplexTypeDefinition td;
        XSDConcreteComponent concreteComponent = null;
        if (referencingObject instanceof Adapter) {
            Adapter adpater = (Adapter)referencingObject;
            if (adpater.getTarget() instanceof XSDConcreteComponent) {
                concreteComponent = (XSDConcreteComponent)adpater.getTarget();
            }
        } else if (referencingObject instanceof XSDConcreteComponent) {
            concreteComponent = (XSDConcreteComponent)referencingObject;
        }
        if (concreteComponent instanceof XSDComplexTypeDefinition) {
            if (component.isNew()) {
                BaseCommand command2;
                td = null;
                if (component.getMetaName() == IXSDSearchConstants.COMPLEX_TYPE_META_NAME) {
                    command2 = new AddXSDComplexTypeDefinitionCommand(Messages._UI_ACTION_ADD_COMPLEX_TYPE, (XSDConcreteComponent)concreteComponent.getSchema());
                    ((AddXSDComplexTypeDefinitionCommand)command2).setNameToAdd(component.getName());
                    ((AddXSDComplexTypeDefinitionCommand)command2).execute();
                    td = ((AddXSDComplexTypeDefinitionCommand)command2).getCreatedComplexType();
                } else {
                    command2 = new AddXSDSimpleTypeDefinitionCommand(Messages._UI_ACTION_ADD_SIMPLE_TYPE, (XSDConcreteComponent)concreteComponent.getSchema());
                    ((AddXSDSimpleTypeDefinitionCommand)command2).setNameToAdd(component.getName());
                    ((AddXSDSimpleTypeDefinitionCommand)command2).execute();
                    td = ((AddXSDSimpleTypeDefinitionCommand)command2).getCreatedSimpleType();
                }
                if (td != null) {
                    command2 = new SetBaseTypeCommand(concreteComponent, (XSDTypeDefinition)td);
                    command2.execute();
                }
            } else {
                command = new SetBaseTypeAndManagerDirectivesCommand(concreteComponent, component.getName(), component.getQualifier(), component.getFile());
                command.execute();
            }
        } else if (concreteComponent instanceof XSDSimpleTypeDefinition) {
            if (component.isNew()) {
                BaseCommand command3;
                td = null;
                if (component.getMetaName() == IXSDSearchConstants.SIMPLE_TYPE_META_NAME) {
                    command3 = new AddXSDSimpleTypeDefinitionCommand(Messages._UI_ACTION_ADD_SIMPLE_TYPE, (XSDConcreteComponent)concreteComponent.getSchema());
                    ((AddXSDSimpleTypeDefinitionCommand)command3).setNameToAdd(component.getName());
                    ((AddXSDSimpleTypeDefinitionCommand)command3).execute();
                    td = ((AddXSDSimpleTypeDefinitionCommand)command3).getCreatedSimpleType();
                }
                if (td != null) {
                    command3 = new SetBaseTypeCommand(concreteComponent, (XSDTypeDefinition)td);
                    command3.execute();
                }
            } else {
                command = new SetBaseTypeAndManagerDirectivesCommand(concreteComponent, component.getName(), component.getQualifier(), component.getFile());
                command.execute();
            }
        }
    }
}

