/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.SpecificationForExtensionsSchema;
import org.w3c.dom.Element;

public class ExtensionsSchemasRegistry {
    private static final String LOCATION_PREFIX = "platform:/plugin/";
    public static final String DESCRIPTION = "description";
    public static final String DISPLAYNAME = "displayName";
    public static final String NAMESPACEURI = "namespaceURI";
    public static final String XSDFILEURL = "xsdFileURL";
    public static final String LABELPROVIDER = "labelProviderClass";
    protected String extensionId;
    HashMap propertyMap;
    ArrayList nsURIProperties;
    private ICatalog systemCatalog;
    private String deprecatedExtensionId;

    public ExtensionsSchemasRegistry(String appinfo_extensionid) {
        this.extensionId = appinfo_extensionid;
    }

    public void __internalSetDeprecatedExtensionId(String deprecatedId) {
        this.deprecatedExtensionId = deprecatedId;
    }

    public List getAllExtensionsSchemasContribution() {
        if (this.nsURIProperties != null) {
            return this.nsURIProperties;
        }
        this.nsURIProperties = new ArrayList();
        this.propertyMap = new HashMap();
        this.getAllExtensionsSchemasContribution(this.extensionId);
        if (this.deprecatedExtensionId != null) {
            this.getAllExtensionsSchemasContribution(this.deprecatedExtensionId);
        }
        return this.nsURIProperties;
    }

    private List getAllExtensionsSchemasContribution(String id) {
        boolean hasASIProperties;
        IConfigurationElement[] asiPropertiesList = Platform.getExtensionRegistry().getConfigurationElementsFor(id);
        boolean bl = hasASIProperties = asiPropertiesList != null && asiPropertiesList.length > 0;
        if (hasASIProperties) {
            int i = 0;
            while (i < asiPropertiesList.length) {
                IConfigurationElement asiPropertiesElement = asiPropertiesList[i];
                String description = asiPropertiesElement.getAttribute(DESCRIPTION);
                String displayName = asiPropertiesElement.getAttribute(DISPLAYNAME);
                String namespaceURI = asiPropertiesElement.getAttribute(NAMESPACEURI);
                String xsdFileURL = asiPropertiesElement.getAttribute(XSDFILEURL);
                String labelProviderClass = asiPropertiesElement.getAttribute(LABELPROVIDER);
                if (displayName != null) {
                    if (xsdFileURL == null) {
                        xsdFileURL = this.locateFileUsingCatalog(namespaceURI);
                    }
                    SpecificationForExtensionsSchema extensionsSchemaSpec = this.createEntry();
                    extensionsSchemaSpec.setDescription(description);
                    extensionsSchemaSpec.setDisplayName(displayName);
                    extensionsSchemaSpec.setNamespaceURI(namespaceURI);
                    extensionsSchemaSpec.setDefautSchema();
                    if (labelProviderClass != null) {
                        String pluginId = asiPropertiesElement.getDeclaringExtension().getContributor().getName();
                        ILabelProvider labelProvider = null;
                        try {
                            Class theClass = Platform.getBundle((String)pluginId).loadClass(labelProviderClass);
                            if (theClass != null && (labelProvider = (ILabelProvider)theClass.newInstance()) != null) {
                                this.propertyMap.put(namespaceURI, labelProvider);
                                extensionsSchemaSpec.setLabelProvider(labelProvider);
                            }
                        }
                        catch (Exception exception) {}
                    }
                    String plugin = asiPropertiesElement.getDeclaringExtension().getContributor().getName();
                    extensionsSchemaSpec.setLocation(LOCATION_PREFIX + plugin + "/" + xsdFileURL);
                    this.nsURIProperties.add(extensionsSchemaSpec);
                }
                ++i;
            }
        }
        return this.nsURIProperties;
    }

    public ILabelProvider getLabelProvider(Element element) {
        return null;
    }

    public SpecificationForExtensionsSchema createEntry() {
        return new SpecificationForExtensionsSchema();
    }

    private String locateFileUsingCatalog(String namespaceURI) {
        this.retrieveCatalog();
        ICatalogEntry[] entries = this.systemCatalog.getCatalogEntries();
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getKey().equals(namespaceURI)) {
                return entries[i].getURI();
            }
            ++i;
        }
        return null;
    }

    private void retrieveCatalog() {
        if (this.systemCatalog != null) {
            return;
        }
        ICatalog defaultCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        INextCatalog[] nextCatalogs = defaultCatalog.getNextCatalogs();
        int i = 0;
        while (i < nextCatalogs.length) {
            INextCatalog catalog = nextCatalogs[i];
            ICatalog referencedCatalog = catalog.getReferencedCatalog();
            if (referencedCatalog != null && "system_catalog".equals(referencedCatalog.getId())) {
                this.systemCatalog = referencedCatalog;
            }
            ++i;
        }
    }
}

