/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo;

import org.eclipse.gef.commands.Command;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateAttributeValueCommand;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.ExtensionItem;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class DOMExtensionItem
extends ExtensionItem {
    Node node;
    Element parent;
    CMNode cmNode;

    DOMExtensionItem(Node node) {
        this.node = node;
    }

    DOMExtensionItem(Element parent, CMElementDeclaration ed) {
        this.parent = parent;
        this.cmNode = ed;
    }

    DOMExtensionItem(Element parent, CMAttributeDeclaration ad) {
        this.parent = parent;
        this.cmNode = ad;
    }

    public String getName() {
        if (this.node instanceof Attr) {
            Attr attr = (Attr)this.node;
            return attr.getName();
        }
        if (this.cmNode instanceof CMAttributeDeclaration) {
            CMAttributeDeclaration ad = (CMAttributeDeclaration)this.cmNode;
            return ad.getNodeName();
        }
        if (this.cmNode instanceof CMDataType) {
            return "text()";
        }
        return "";
    }

    public String getValue() {
        String value;
        if (this.node instanceof Attr) {
            Attr attr = (Attr)this.node;
            return attr.getValue();
        }
        if (this.cmNode instanceof CMAttributeDeclaration && (value = this.parent.getAttribute(this.cmNode.getNodeName())) != null) {
            return value;
        }
        return "";
    }

    public String[] getPossibleValues() {
        String[] result = new String[]{};
        if (this.node instanceof Attr) {
            CMAttributeDeclaration ad;
            Attr attr = (Attr)this.node;
            ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)attr.getOwnerDocument());
            if (modelQuery != null && (ad = modelQuery.getCMAttributeDeclaration(attr)) != null) {
                result = modelQuery.getPossibleDataTypeValues(attr.getOwnerElement(), (CMNode)ad);
            }
        } else if (this.parent != null && this.cmNode != null && !(this.cmNode instanceof CMDataType) && this.cmNode instanceof CMAttributeDeclaration) {
            CMAttributeDeclaration ad = (CMAttributeDeclaration)this.cmNode;
            ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)this.parent.getOwnerDocument());
            if (modelQuery != null) {
                result = modelQuery.getPossibleDataTypeValues(this.parent, (CMNode)ad);
            }
        }
        return result;
    }

    public Command getUpdateValueCommand(String newValue) {
        if (this.node instanceof Attr) {
            Attr attr = (Attr)this.node;
            return new UpdateAttributeValueCommand(attr.getOwnerElement(), attr.getNodeName(), newValue);
        }
        if (this.parent != null && this.cmNode != null && !(this.cmNode instanceof CMDataType) && this.cmNode instanceof CMAttributeDeclaration) {
            CMAttributeDeclaration ad = (CMAttributeDeclaration)this.cmNode;
            return new UpdateAttributeValueCommand(this.parent, ad.getAttrName(), newValue);
        }
        return null;
    }

    public String getNamespace() {
        String namespace = null;
        if (this.node != null) {
            if (this.node.getNodeType() == 1) {
                namespace = this.node.getNamespaceURI();
            } else if (this.node.getNodeType() == 2) {
                Attr attr = (Attr)this.node;
                namespace = attr.getOwnerElement().getNamespaceURI();
            }
        } else if (this.parent != null) {
            namespace = this.parent.getNamespaceURI();
        }
        return namespace;
    }

    public Node getParentNode() {
        Node parentNode = null;
        if (this.node != null) {
            if (this.node.getNodeType() == 1) {
                parentNode = this.node.getParentNode();
            } else if (this.node.getNodeType() == 2) {
                Attr attr = (Attr)this.node;
                parentNode = attr.getOwnerElement();
            }
        } else if (this.parent != null) {
            parentNode = this.parent;
        }
        return parentNode;
    }

    public String getParentName() {
        Node parentNode = this.getParentNode();
        return parentNode != null ? parentNode.getLocalName() : "";
    }

    public Node getNode() {
        return this.node;
    }
}

