/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adt.design.editparts;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.IActionProvider;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.IFeedbackHandler;
import org.eclipse.wst.xsd.ui.internal.adt.design.figures.IFigureFactory;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IADTObject;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IADTObjectListener;

public abstract class BaseEditPart
extends AbstractGraphicalEditPart
implements IActionProvider,
IADTObjectListener,
IFeedbackHandler {
    protected static final String[] EMPTY_ACTION_ARRAY = new String[0];
    protected boolean isSelected = false;
    private ZoomListener zoomListener = new ZoomListener(){

        public void zoomChanged(double zoom) {
            BaseEditPart.this.handleZoomChanged();
        }
    };

    public IFigureFactory getFigureFactory() {
        EditPartFactory factory = this.getViewer().getEditPartFactory();
        Assert.isTrue((boolean)(factory instanceof IFigureFactory), (String)"EditPartFactory must be an instanceof of IFigureFactory");
        return (IFigureFactory)factory;
    }

    public String[] getActions(Object object) {
        Object model = this.getModel();
        if (model instanceof IActionProvider) {
            return ((IActionProvider)model).getActions(object);
        }
        return EMPTY_ACTION_ARRAY;
    }

    protected void addActionsToList(List list, IAction[] actions) {
        int i = 0;
        while (i < actions.length) {
            list.add(actions[i]);
            ++i;
        }
    }

    public void activate() {
        super.activate();
        Object model = this.getModel();
        if (model instanceof IADTObject) {
            IADTObject object = (IADTObject)model;
            object.registerListener(this);
        }
        if (this.getZoomManager() != null) {
            this.getZoomManager().addZoomListener(this.zoomListener);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deactivate() {
        try {
            Object model = this.getModel();
            if (model instanceof IADTObject) {
                IADTObject object = (IADTObject)model;
                object.unregisterListener(this);
            }
            if (this.getZoomManager() != null) {
                this.getZoomManager().removeZoomListener(this.zoomListener);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            super.deactivate();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        super.deactivate();
    }

    public void propertyChanged(Object object, String property) {
        this.refresh();
    }

    public void refresh() {
        super.refresh();
        Iterator i = this.getChildren().iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof BaseEditPart) {
                ((BaseEditPart)obj).refresh();
                continue;
            }
            if (!(obj instanceof AbstractGraphicalEditPart)) continue;
            ((AbstractGraphicalEditPart)obj).refresh();
        }
    }

    public void addFeedback() {
        this.isSelected = true;
        this.refreshVisuals();
    }

    public void removeFeedback() {
        this.isSelected = false;
        this.refreshVisuals();
    }

    public ZoomManager getZoomManager() {
        return ((ScalableRootEditPart)this.getRoot()).getZoomManager();
    }

    public Rectangle getZoomedBounds(Rectangle r) {
        double factor = this.getZoomManager().getZoom();
        int x = (int)Math.round((double)r.x * factor);
        int y = (int)Math.round((double)r.y * factor);
        int width = (int)Math.round((double)r.width * factor);
        int height = (int)Math.round((double)r.height * factor);
        return new Rectangle(x, y, width, height);
    }

    protected void handleZoomChanged() {
        this.refreshVisuals();
    }

    public IEditorPart getEditorPart() {
        IWorkbenchWindow workbenchWindow;
        IEditorPart editorPart = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (workbenchWindow = workbench.getActiveWorkbenchWindow()) != null && workbenchWindow.getActivePage() != null) {
            editorPart = workbenchWindow.getActivePage().getActiveEditor();
        }
        return editorPart;
    }
}

