/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.ui.internal.navigator;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jst.servlet.ui.internal.navigator.CompressedJavaProject;
import org.eclipse.jst.servlet.ui.internal.navigator.ICompressedNode;
import org.eclipse.jst.servlet.ui.internal.plugin.WEBUIMessages;
import org.eclipse.swt.graphics.Image;

public class CompressedJavaLibraries
implements ICompressedNode {
    private CompressedJavaProject compressedProject;
    private Image image;

    public CompressedJavaLibraries(CompressedJavaProject compressedProject) {
        this.compressedProject = compressedProject;
    }

    public Image getImage() {
        if (this.image == null) {
            this.image = JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.library_obj.gif");
        }
        return this.image;
    }

    public String getLabel() {
        return WEBUIMessages.Compressed_Libraries;
    }

    public Object[] getChildren(ITreeContentProvider delegateContentProvider) {
        ArrayList<Object> classpathContainers = new ArrayList<Object>();
        Object[] delegateChildren = delegateContentProvider.getChildren((Object)this.compressedProject.getProject());
        int i = 0;
        while (i < delegateChildren.length) {
            if (delegateChildren[i] instanceof IPackageFragmentRoot) {
                try {
                    IClasspathEntry rawClasspathEntry = ((IPackageFragmentRoot)delegateChildren[i]).getRawClasspathEntry();
                    if (rawClasspathEntry.getEntryKind() != 5 && rawClasspathEntry.getEntryKind() != 3) {
                        classpathContainers.add(delegateChildren[i]);
                    }
                }
                catch (JavaModelException javaModelException) {}
            } else if (!(delegateChildren[i] instanceof IJavaElement) && !(delegateChildren[i] instanceof IResource)) {
                classpathContainers.add(delegateChildren[i]);
            }
            ++i;
        }
        return classpathContainers.toArray();
    }

    public CompressedJavaProject getCompressedProject() {
        return this.compressedProject;
    }
}

