/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.jdt.internal.classpath;

import java.lang.reflect.Field;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.jdt.internal.classpath.ClasspathDecorations;
import org.eclipse.jst.common.jdt.internal.classpath.ClasspathDecorationsManager;
import org.eclipse.jst.common.jdt.internal.classpath.FlexibleProjectContainer;

public abstract class FlexibleProjectContainerInitializer
extends ClasspathContainerInitializer {
    private static final ClasspathDecorationsManager decorations = FlexibleProjectContainer.getDecorationsManager();

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return true;
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer sg) throws CoreException {
        String cid = containerPath.toString();
        IClasspathEntry[] entries = sg.getClasspathEntries();
        decorations.clearAllDecorations(cid);
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            IPath srcpath = entry.getSourceAttachmentPath();
            IPath srcrootpath = entry.getSourceAttachmentRootPath();
            IClasspathAttribute[] attrs = entry.getExtraAttributes();
            if (srcpath != null || attrs.length > 0) {
                String eid = entry.getPath().toString();
                ClasspathDecorations dec = new ClasspathDecorations();
                dec.setSourceAttachmentPath(srcpath);
                dec.setSourceAttachmentRootPath(srcrootpath);
                dec.setExtraAttributes(attrs);
                decorations.setDecorations(cid, eid, dec);
            }
            ++i;
        }
        decorations.save();
        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)project);
        FlexibleProjectContainerInitializer.refresh(container);
    }

    private static void refresh(IClasspathContainer container) {
        if (container instanceof FlexibleProjectContainer) {
            ((FlexibleProjectContainer)container).refresh();
        } else {
            try {
                Field field = container.getClass().getDeclaredField("fOriginal");
                field.setAccessible(true);
                FlexibleProjectContainerInitializer.refresh((IClasspathContainer)field.get(container));
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

