/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.jdt.internal.classpath;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jst.common.frameworks.CommonFrameworksPlugin;
import org.eclipse.jst.common.jdt.internal.classpath.ClasspathDecorations;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ClasspathDecorationsManager {
    private final File f;
    private final HashMap decorations;

    public ClasspathDecorationsManager(String plugin) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        File wsdir = ws.getRoot().getLocation().toFile();
        File wsmdroot = new File(wsdir, ".metadata/.plugins");
        File pmdroot = new File(wsmdroot, plugin);
        this.f = new File(pmdroot, "classpath.decorations.xml");
        this.decorations = this.read();
    }

    public ClasspathDecorations getDecorations(String container, String entry) {
        HashMap submap = (HashMap)this.decorations.get(container);
        if (submap == null) {
            return null;
        }
        return (ClasspathDecorations)submap.get(entry);
    }

    public void setDecorations(String container, String entry, ClasspathDecorations dec) {
        HashMap<String, ClasspathDecorations> submap = (HashMap<String, ClasspathDecorations>)this.decorations.get(container);
        if (submap == null) {
            submap = new HashMap<String, ClasspathDecorations>();
            this.decorations.put(container, submap);
        }
        submap.put(entry, dec);
    }

    public void clearAllDecorations(String container) {
        this.decorations.remove(container);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save() {
        File folder = this.f.getParentFile();
        if (!folder.exists() && !folder.mkdirs()) {
            return;
        }
        PrintWriter w = null;
        try {
            try {
                w = new PrintWriter(new BufferedWriter(new FileWriter(this.f)));
                w.println("<classpath>");
                Iterator itr1 = this.decorations.entrySet().iterator();
                while (itr1.hasNext()) {
                    Map.Entry entry1 = itr1.next();
                    Map submap = (Map)entry1.getValue();
                    w.print("  <container id=\"");
                    w.print((String)entry1.getKey());
                    w.println("\">");
                    Iterator itr2 = submap.entrySet().iterator();
                    while (itr2.hasNext()) {
                        Map.Entry entry2 = itr2.next();
                        ClasspathDecorations dec = (ClasspathDecorations)entry2.getValue();
                        w.print("    <entry id=\"");
                        w.print((String)entry2.getKey());
                        w.println("\">");
                        if (dec.getSourceAttachmentPath() != null) {
                            w.print("      <source-attachment-path>");
                            w.print(dec.getSourceAttachmentPath().toString());
                            w.println("</source-attachment-path>");
                        }
                        if (dec.getSourceAttachmentRootPath() != null) {
                            w.print("      <source-attachment-root-path>");
                            w.print(dec.getSourceAttachmentRootPath().toString());
                            w.println("</source-attachment-root-path>");
                        }
                        IClasspathAttribute[] attrs = dec.getExtraAttributes();
                        int i = 0;
                        while (i < attrs.length) {
                            IClasspathAttribute attr = attrs[i];
                            w.print("      <attribute name=\"");
                            w.print(attr.getName());
                            w.print("\">");
                            w.print(attr.getValue());
                            w.println("</attribute>");
                            ++i;
                        }
                        w.println("    </entry>");
                    }
                    w.println("  </container>");
                }
                w.println("</classpath>");
            }
            catch (IOException e) {
                CommonFrameworksPlugin.log(e);
            }
            Object var12_15 = null;
            w.close();
            return;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            w.close();
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    private HashMap read() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 110->113)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String text(Element el) {
        NodeList nodes = el.getChildNodes();
        String str = null;
        StringBuffer buf = null;
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 3) {
                String val = node.getNodeValue();
                if (buf != null) {
                    buf.append(val);
                } else if (str != null) {
                    buf = new StringBuffer();
                    buf.append(str);
                    buf.append(val);
                    str = null;
                } else {
                    str = val;
                }
            }
            ++i;
        }
        if (buf != null) {
            return buf.toString();
        }
        return str;
    }

    private static Iterator elements(Element el, String name) {
        return new ElementsIterator(el, name);
    }

    private static Iterator elements(Element el) {
        return new ElementsIterator(el, null);
    }

    private static final class ElementsIterator
    implements Iterator {
        private final NodeList nodes;
        private final int length;
        private final String name;
        private int position;
        private Element element;

        public ElementsIterator(Element parent, String name) {
            this.nodes = parent.getChildNodes();
            this.length = this.nodes.getLength();
            this.position = -1;
            this.name = name;
            this.advance();
        }

        private void advance() {
            this.element = null;
            ++this.position;
            while (this.position < this.length && this.element == null) {
                Node node = this.nodes.item(this.position);
                if (node.getNodeType() == 1 && (this.name == null || node.getNodeName().equals(this.name))) {
                    this.element = (Element)node;
                }
                ++this.position;
            }
        }

        public boolean hasNext() {
            return this.element != null;
        }

        public Object next() {
            Element el = this.element;
            if (el == null) {
                throw new NoSuchElementException();
            }
            this.advance();
            return el;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

