/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IPublishListener;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.util.PublishAdapter;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;
import org.eclipse.wst.server.ui.internal.view.servers.ServerAction;
import org.eclipse.wst.server.ui.internal.view.servers.ServerTableLabelProvider;
import org.eclipse.wst.server.ui.internal.view.servers.ServersView;

public class ServerTableViewer
extends TreeViewer {
    protected static final String ROOT = "root";
    protected IServerLifecycleListener serverResourceListener;
    protected IPublishListener publishListener;
    protected IServerListener serverListener;
    protected static Object deletedElement = null;
    protected static List publishing = new ArrayList();
    protected static List starting = new ArrayList();
    protected ServerTableLabelProvider labelProvider;
    protected ISelectionListener dsListener;
    protected ServersView view;
    protected Thread thread = null;
    protected boolean stopThread = false;

    protected void startThread() {
        this.stopThread = false;
        if (this.thread != null) {
            return;
        }
        this.thread = new Thread("Servers View Animator"){

            public void run() {
                while (!ServerTableViewer.this.stopThread) {
                    try {
                        ServerTableViewer.this.labelProvider.animate();
                        Object[] rootElements = ((ITreeContentProvider)ServerTableViewer.this.getContentProvider()).getElements(null);
                        Display.getDefault().asyncExec(new Runnable(this, rootElements){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ Object[] val$rootElements;
                            {
                                this.this$1 = var1_1;
                                this.val$rootElements = objectArray;
                            }

                            public void run() {
                                if (1.access$0(this.this$1).getTree() != null && !1.access$0(this.this$1).getTree().isDisposed()) {
                                    1.access$0(this.this$1).update(this.val$rootElements, null);
                                }
                            }
                        });
                        Thread.sleep(250L);
                    }
                    catch (Exception e) {
                        Trace.trace(Trace.FINEST, "Error in animated server view", e);
                    }
                    ServerTableViewer.this.thread = null;
                }
            }

            static /* synthetic */ ServerTableViewer access$0(1 var0) {
                return var0.ServerTableViewer.this;
            }
        };
        this.thread.setDaemon(true);
        this.thread.start();
    }

    protected void stopThread() {
        this.stopThread = true;
    }

    public ServerTableViewer(ServersView view, Tree tree) {
        super(tree);
        this.view = view;
        this.setContentProvider((IContentProvider)new ServerContentProvider());
        this.labelProvider = new ServerTableLabelProvider();
        this.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.setSorter(new ViewerSorter(){});
        this.setInput(ROOT);
        this.addListeners();
        IActionBars actionBars = view.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)new ServerAction(this.getControl().getShell(), (ISelectionProvider)this, "Delete it!", 1));
    }

    protected void addListeners() {
        this.serverResourceListener = new IServerLifecycleListener(){

            public void serverAdded(IServer server) {
                ServerTableViewer.this.addServer(server);
                server.addServerListener(ServerTableViewer.this.serverListener);
                ((Server)server).addPublishListener(ServerTableViewer.this.publishListener);
            }

            public void serverChanged(IServer server) {
                ServerTableViewer.this.refreshServer(server);
            }

            public void serverRemoved(IServer server) {
                ServerTableViewer.this.removeServer(server);
                server.removeServerListener(ServerTableViewer.this.serverListener);
                ((Server)server).removePublishListener(ServerTableViewer.this.publishListener);
            }
        };
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)this.serverResourceListener);
        this.publishListener = new PublishAdapter(){

            public void publishStarted(IServer server) {
                ServerTableViewer.this.handlePublishChange(server, true);
            }

            public void publishFinished(IServer server, IStatus status) {
                ServerTableViewer.this.handlePublishChange(server, false);
            }
        };
        this.serverListener = new IServerListener(){

            public void serverChanged(ServerEvent event) {
                if (event == null) {
                    return;
                }
                int eventKind = event.getKind();
                IServer server = event.getServer();
                if ((eventKind & 0x10) != 0) {
                    if ((eventKind & 1) != 0) {
                        ServerTableViewer.this.refreshServer(server);
                        int state = event.getState();
                        String id = server.getId();
                        if (state == 1 || state == 3) {
                            if (!starting.contains(id)) {
                                if (starting.isEmpty()) {
                                    ServerTableViewer.this.startThread();
                                }
                                starting.add(id);
                            }
                        } else if (starting.contains(id)) {
                            starting.remove(id);
                            if (starting.isEmpty()) {
                                ServerTableViewer.this.stopThread();
                            }
                        }
                    } else {
                        ServerTableViewer.this.refreshServer(server);
                    }
                } else if ((eventKind & 0x20) != 0 && ((eventKind & 1) != 0 || (eventKind & 2) != 0)) {
                    ServerTableViewer.this.refreshServer(server);
                }
            }
        };
        IServer[] servers = ServerCore.getServers();
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size) {
                servers[i].addServerListener(this.serverListener);
                ((Server)servers[i]).addPublishListener(this.publishListener);
                ++i;
            }
        }
    }

    protected void refreshServer(final IServer server) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    ServerTableViewer.this.refresh(server);
                    ISelection sel = ServerTableViewer.this.getSelection();
                    ServerTableViewer.this.setSelection(sel);
                }
                catch (Exception exception) {}
            }
        });
    }

    protected void handleDispose(DisposeEvent event) {
        this.stopThread();
        ServerCore.removeServerLifecycleListener((IServerLifecycleListener)this.serverResourceListener);
        IServer[] servers = ServerCore.getServers();
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size) {
                servers[i].removeServerListener(this.serverListener);
                ((Server)servers[i]).removePublishListener(this.publishListener);
                ++i;
            }
        }
        super.handleDispose(event);
    }

    protected void handlePublishChange(IServer server, boolean isPublishing) {
        String serverId = server.getId();
        if (isPublishing) {
            publishing.add(serverId);
        } else {
            publishing.remove(serverId);
        }
        this.refreshServer(server);
    }

    protected void handleServerModulesChanged(IServer server2) {
        if (server2 == null) {
            return;
        }
        IServer[] servers = ServerCore.getServers();
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size) {
                if (server2.equals(servers[i])) {
                    this.refresh(servers[i]);
                }
                ++i;
            }
        }
    }

    protected void handleServerResourceAdded(IServer server) {
        this.add(null, server);
    }

    protected void handleServerResourceChanged(IServer server) {
        this.refresh(server);
    }

    protected void handleServerResourceRemoved(IServer server) {
        this.remove(server);
        String serverId = server.getId();
        publishing.remove(serverId);
        this.view.getViewSite().getActionBars().getStatusLineManager().setMessage(null, null);
    }

    protected void addServer(final IServer server) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ServerTableViewer.this.add(ServerTableViewer.ROOT, server);
            }
        });
    }

    protected void removeServer(final IServer server) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ServerTableViewer.this.remove(server);
            }
        });
    }

    public class ServerContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        public Object[] getElements(Object element) {
            ArrayList<IServer> list = new ArrayList<IServer>();
            IServer[] servers = ServerCore.getServers();
            if (servers != null) {
                int size = servers.length;
                int i = 0;
                while (i < size) {
                    if (!((Server)servers[i]).isPrivate()) {
                        list.add(servers[i]);
                    }
                    ++i;
                }
            }
            return list.toArray();
        }

        public void inputChanged(Viewer theViewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object element) {
            if (element instanceof ModuleServer) {
                ModuleServer ms = (ModuleServer)element;
                try {
                    IModule[] children = ms.server.getChildModules(ms.module, null);
                    int size = children.length;
                    Object[] ms2 = new ModuleServer[size];
                    int i = 0;
                    while (i < size) {
                        int size2 = ms.module.length;
                        IModule[] module = new IModule[size2 + 1];
                        System.arraycopy(ms.module, 0, module, 0, size2);
                        module[size2] = children[i];
                        ms2[i] = new ModuleServer(ms.server, module);
                        ++i;
                    }
                    return ms2;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            IServer server = (IServer)element;
            IModule[] modules = server.getModules();
            int size = modules.length;
            Object[] ms = new ModuleServer[size];
            int i = 0;
            while (i < size) {
                ms[i] = new ModuleServer(server, new IModule[]{modules[i]});
                ++i;
            }
            return ms;
        }

        public Object getParent(Object element) {
            if (element instanceof ModuleServer) {
                ModuleServer ms = (ModuleServer)element;
                return ms.server;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ModuleServer) {
                ModuleServer curModuleServer = (ModuleServer)element;
                IServer curServer = curModuleServer.server;
                IModule[] curModule = curModuleServer.module;
                if (curServer != null && curModule != null) {
                    IModule[] curChildModule = curServer.getChildModules(curModule, null);
                    return curChildModule != null && curChildModule.length > 0;
                }
                return false;
            }
            IServer server = (IServer)element;
            return server.getModules().length > 0;
        }
    }
}

