/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common.classpath;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.internal.common.J2EECommonMessages;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class J2EEComponentClasspathContainer
implements IClasspathContainer {
    public static final String CONTAINER_ID = "org.eclipse.jst.j2ee.internal.module.container";
    public static final IPath CONTAINER_PATH = new Path("org.eclipse.jst.j2ee.internal.module.container");
    private static IPath WEBLIB = new Path("/WEB-INF/lib");
    private IPath containerPath;
    private IJavaProject javaProject;
    private IClasspathEntry[] entries = new IClasspathEntry[0];
    private LastUpdate lastUpdate = new LastUpdate();

    public J2EEComponentClasspathContainer(IPath path, IJavaProject javaProject) {
        this.containerPath = path;
        this.javaProject = javaProject;
        this.update();
    }

    private boolean requiresUpdate() {
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.javaProject.getProject());
        if (component == null) {
            return false;
        }
        IVirtualReference[] refs = component.getReferences();
        IVirtualComponent comp = null;
        if (refs.length == this.lastUpdate.refCount) {
            int i = 0;
            while (i < this.lastUpdate.refCount) {
                comp = refs[i].getReferencedComponent();
                if (comp.isBinary() != this.lastUpdate.isBinary[i]) {
                    return true;
                }
                IPath path = null;
                if (comp.isBinary()) {
                    VirtualArchiveComponent archiveComp = (VirtualArchiveComponent)comp;
                    File diskFile = archiveComp.getUnderlyingDiskFile();
                    if (diskFile.exists()) {
                        path = new Path(diskFile.getAbsolutePath());
                    } else {
                        IFile iFile = archiveComp.getUnderlyingWorkbenchFile();
                        path = iFile.getFullPath();
                    }
                } else {
                    path = comp.getProject().getFullPath();
                }
                if (!path.equals((Object)this.lastUpdate.paths[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void update() {
        component = ComponentCore.createComponent((IProject)this.javaProject.getProject());
        if (component == null) {
            return;
        }
        refs = component.getReferences();
        comp = null;
        LastUpdate.access$4(this.lastUpdate, refs.length);
        LastUpdate.access$5(this.lastUpdate, new boolean[LastUpdate.access$1(this.lastUpdate)]);
        LastUpdate.access$6(this.lastUpdate, new IPath[LastUpdate.access$1(this.lastUpdate)]);
        isWeb = J2EEProjectUtilities.isDynamicWebProject(component.getProject());
        shouldAdd = true;
        entriesList = new ArrayList<IClasspathEntry>();
        try {
            javaProject = JavaCore.create((IProject)component.getProject());
            existingEntries = new HashSet<IClasspathEntry>();
            try {
                existingEntries.addAll(Arrays.asList(javaProject.getResolvedClasspath(true)));
                cp = javaProject.getRawClasspath();
                i = 0;
                while (i < cp.length) {
                    path = cp[i].getPath();
                    if (path.equals((Object)J2EEComponentClasspathContainer.CONTAINER_PATH) && (container = JavaCore.getClasspathContainer((IPath)path, (IJavaProject)javaProject)) != null) {
                        containerEntries = container.getClasspathEntries();
                        existingEntries.removeAll(Arrays.asList(containerEntries));
                        break;
                    }
                    ++i;
                }
                existingEntries.removeAll(Arrays.asList(this.entries));
            }
            catch (JavaModelException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            i = 0;
            while (i < refs.length) {
                comp = refs[i].getReferencedComponent();
                LastUpdate.access$2((LastUpdate)this.lastUpdate)[i] = comp.isBinary();
                v0 = shouldAdd = isWeb == false || refs[i].getRuntimePath().equals((Object)J2EEComponentClasspathContainer.WEBLIB) == false;
                if (shouldAdd) {
                    if (comp.isBinary()) {
                        archiveComp = (VirtualArchiveComponent)comp;
                        diskFile = archiveComp.getUnderlyingDiskFile();
                        if (diskFile.exists()) {
                            LastUpdate.access$3((LastUpdate)this.lastUpdate)[i] = new Path(diskFile.getAbsolutePath());
                        } else {
                            iFile = archiveComp.getUnderlyingWorkbenchFile();
                            LastUpdate.access$3((LastUpdate)this.lastUpdate)[i] = iFile.getFullPath();
                        }
                        if (!J2EEComponentClasspathContainer.isAlreadyOnClasspath(existingEntries, LastUpdate.access$3(this.lastUpdate)[i])) {
                            entriesList.add(JavaCore.newLibraryEntry((IPath)LastUpdate.access$3(this.lastUpdate)[i], null, null));
                        }
                    } else {
                        project = comp.getProject();
                        LastUpdate.access$3((LastUpdate)this.lastUpdate)[i] = project.getFullPath();
                        if (!J2EEComponentClasspathContainer.isAlreadyOnClasspath(existingEntries, LastUpdate.access$3(this.lastUpdate)[i])) {
                            entriesList.add(JavaCore.newProjectEntry((IPath)LastUpdate.access$3(this.lastUpdate)[i], (boolean)false));
                        }
                    }
                }
                ++i;
            }
            ** GOTO lbl-1000
        }
        catch (Throwable var15_18) {
            var14_19 = null;
            this.entries = new IClasspathEntry[entriesList.size()];
            i = 0;
        }
        while (true) {
            if (i >= this.entries.length) {
                throw var15_18;
            }
            this.entries[i] = (IClasspathEntry)entriesList.get(i);
            ++i;
        }
lbl-1000:
        // 1 sources

        {
            var14_20 = null;
        }
        this.entries = new IClasspathEntry[entriesList.size()];
        i = 0;
        while (true) {
            if (i >= this.entries.length) {
                return;
            }
            this.entries[i] = (IClasspathEntry)entriesList.get(i);
            ++i;
        }
    }

    public void install() {
        IJavaProject[] projects = new IJavaProject[]{this.javaProject};
        IClasspathContainer[] conts = new IClasspathContainer[]{new J2EEComponentClasspathContainer(this.containerPath, this.javaProject)};
        try {
            JavaCore.setClasspathContainer((IPath)this.containerPath, (IJavaProject[])projects, (IClasspathContainer[])conts, null);
        }
        catch (JavaModelException e) {
            Logger.getLogger().log((Throwable)e);
        }
    }

    public void refresh() {
        if (this.requiresUpdate()) {
            this.install();
        }
    }

    public IClasspathEntry[] getClasspathEntries() {
        return this.entries;
    }

    public String getDescription() {
        return J2EECommonMessages.J2EE_MODULE_CLASSPATH_CONTAINER_NAME;
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.containerPath;
    }

    private static boolean isAlreadyOnClasspath(Set classpath, IPath newPath) {
        Iterator itr = classpath.iterator();
        while (itr.hasNext()) {
            IClasspathEntry entry = (IClasspathEntry)itr.next();
            IPath entryPath = entry.getPath();
            if (entryPath.equals((Object)newPath)) {
                return true;
            }
            if (!entryPath.isPrefixOf(newPath) || Util.isExcluded((IPath)newPath, (char[][])((ClasspathEntry)entry).fullInclusionPatternChars(), (char[][])((ClasspathEntry)entry).fullExclusionPatternChars(), (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private class LastUpdate {
        private int refCount = 0;
        private boolean[] isBinary = new boolean[this.refCount];
        private IPath[] paths = new IPath[this.refCount];

        private LastUpdate() {
        }

        static /* synthetic */ void access$4(LastUpdate lastUpdate, int n) {
            lastUpdate.refCount = n;
        }

        static /* synthetic */ void access$5(LastUpdate lastUpdate, boolean[] blArray) {
            lastUpdate.isBinary = blArray;
        }

        static /* synthetic */ void access$6(LastUpdate lastUpdate, IPath[] iPathArray) {
            lastUpdate.paths = iPathArray;
        }
    }
}

