/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.dialogs;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.wsdl.ui.internal.Messages;

public class NewComponentDialog
extends Dialog
implements ModifyListener {
    protected Text nameField;
    protected Button okButton;
    protected String name;
    protected String title;
    protected Label errorMessageLabel;
    protected List usedNames;

    public NewComponentDialog(Shell parentShell, String title, String defaultName) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.name = defaultName;
        this.title = title;
    }

    public NewComponentDialog(Shell parentShell, String title, String defaultName, List usedNames) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.name = defaultName;
        this.title = title;
        this.usedNames = usedNames;
    }

    public int createAndOpen() {
        this.create();
        this.getShell().setText(this.title);
        this.setBlockOnOpen(true);
        return this.open();
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.nameField.forceFocus();
        this.nameField.selectAll();
        this.updateErrorMessage();
        return control;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void createHeaderContent(Composite parent) {
    }

    protected void createExtendedContent(Composite parent) {
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.createHeaderContent(dialogArea);
        Composite composite = new Composite(dialogArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData gdFill = new GridData();
        gdFill.horizontalAlignment = 4;
        gdFill.grabExcessHorizontalSpace = true;
        gdFill.verticalAlignment = 4;
        gdFill.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)gdFill);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(Messages.getString("_UI_LABEL_NAME"));
        this.nameField = new Text(composite, 2052);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 200;
        this.nameField.setLayoutData((Object)gd);
        this.nameField.setText(this.name);
        this.nameField.addModifyListener((ModifyListener)this);
        this.createExtendedContent(dialogArea);
        this.errorMessageLabel = new Label(dialogArea, 0);
        this.errorMessageLabel.setText("error message goes here");
        GridData gd2 = new GridData();
        gd2.horizontalAlignment = 4;
        gd2.grabExcessHorizontalSpace = true;
        gd2.widthHint = 200;
        this.errorMessageLabel.setLayoutData((Object)gd2);
        return dialogArea;
    }

    public void modifyText(ModifyEvent e) {
        this.updateErrorMessage();
    }

    protected String computeErrorMessage(String name) {
        if (this.usedNames == null) {
            return null;
        }
        Iterator iterator = this.usedNames.iterator();
        while (iterator.hasNext()) {
            if (!name.equalsIgnoreCase((String)iterator.next())) continue;
            return Messages.getString("_UI_LABEL_WARNING_DUPLICATE_NAME_EXISTS");
        }
        return null;
    }

    protected void updateErrorMessage() {
        String errorMessage = null;
        String name = this.nameField.getText().trim();
        errorMessage = name.length() > 0 ? this.computeErrorMessage(name) : "";
        this.errorMessageLabel.setText(errorMessage != null ? errorMessage : "");
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.name = this.nameField.getText();
        }
        super.buttonPressed(buttonId);
    }

    public String getName() {
        return this.name;
    }
}

