/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.adapters.visitor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.wsdl.ui.internal.adapters.visitor.W11XSDVisitor;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupContent;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;

public class W11XSDVisitorForFields
extends W11XSDVisitor {
    List concreteComponentList = new ArrayList();
    List thingsWeNeedToListenTo = new ArrayList();

    public void visitComplexTypeDefinition(XSDComplexTypeDefinition type) {
        super.visitComplexTypeDefinition(type);
        if (type.getAttributeContents() != null) {
            Iterator iter = type.getAttributeContents().iterator();
            while (iter.hasNext()) {
                XSDAttributeGroupContent attrGroupContent = (XSDAttributeGroupContent)iter.next();
                if (attrGroupContent instanceof XSDAttributeUse) {
                    XSDAttributeUse attrUse = (XSDAttributeUse)attrGroupContent;
                    this.concreteComponentList.add(attrUse);
                    continue;
                }
                if (!(attrGroupContent instanceof XSDAttributeGroupDefinition)) continue;
                XSDAttributeGroupDefinition attrGroup = (XSDAttributeGroupDefinition)attrGroupContent;
                this.thingsWeNeedToListenTo.add(attrGroup);
                this.visitAttributeGroupDefinition(attrGroup);
            }
        }
    }

    public void visitModelGroup(XSDModelGroup modelGroup) {
        super.visitModelGroup(modelGroup);
        this.thingsWeNeedToListenTo.add(modelGroup);
    }

    public void visitAttributeGroupDefinition(XSDAttributeGroupDefinition attributeGroup) {
        Iterator it = attributeGroup.getContents().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof XSDAttributeUse) {
                XSDAttributeUse attributeUse = (XSDAttributeUse)o;
                this.concreteComponentList.add(attributeUse);
                continue;
            }
            if (!(o instanceof XSDAttributeGroupDefinition)) continue;
            XSDAttributeGroupDefinition attrGroup = (XSDAttributeGroupDefinition)o;
            this.thingsWeNeedToListenTo.add(attrGroup);
            if (!attrGroup.isAttributeGroupDefinitionReference()) continue;
            attrGroup = attrGroup.getResolvedAttributeGroupDefinition();
            this.visitAttributeGroupDefinition(attrGroup);
        }
    }

    public void visitElementDeclaration(XSDElementDeclaration element) {
        this.concreteComponentList.add(element);
    }

    public void visitAttributeDeclaration(XSDAttributeDeclaration attr) {
        super.visitAttributeDeclaration(attr);
        this.concreteComponentList.add(attr);
    }

    public List getConcreteComponentList() {
        return this.concreteComponentList;
    }

    public List getThingsWeNeedToListenTo() {
        return this.thingsWeNeedToListenTo;
    }
}

