/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.mysql.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.core.rte.RefreshManager;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.impl.SchemaImpl;
import org.eclipse.wst.rdb.internal.mysql.MysqlPlugin;
import org.eclipse.wst.rdb.internal.mysql.catalog.MySqlCatalogDatabase;
import org.eclipse.wst.rdb.internal.mysql.catalog.MySqlCatalogTable;

public class MySqlCatalogSchema
extends SchemaImpl
implements ICatalogObject {
    private static final long serialVersionUID = 3257567317125903160L;
    private static final String[] POSSIBLE_TABLE_TYPE_COL_NAMES = new String[]{"Types", "Type", "Engine"};
    private boolean tablesLoaded = false;

    public synchronized void refresh() {
        this.tablesLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getDatabase();
        return ((MySqlCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getDatabase();
    }

    public EList getTables() {
        if (!this.tablesLoaded) {
            this.loadTables();
        }
        return this.tables;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 8) {
            this.getTables();
        } else if (id == 14) {
            this.getRoutines();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadTables() {
        if (this.tablesLoaded) {
            return;
        }
        EList tableList = super.getTables();
        tableList.clear();
        Connection connection = this.getConnection();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            String catalogName = connection.getCatalog();
            if (catalogName == null || catalogName.trim().length() == 0) {
                connection.setCatalog(this.getName());
            }
            String query = "SHOW TABLE STATUS FROM `" + connection.getCatalog() + "`";
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery(query);
            ResultSetMetaData rmd = r.getMetaData();
            String typeStr = null;
            int columnCount = rmd.getColumnCount();
            HashSet<String> possibleTableTypeColNames = new HashSet<String>(Arrays.asList(POSSIBLE_TABLE_TYPE_COL_NAMES));
            int x = 1;
            while (x <= columnCount) {
                String colName = rmd.getColumnName(x).trim();
                if (possibleTableTypeColNames.contains(colName)) {
                    typeStr = colName;
                    break;
                }
                ++x;
            }
            while (r.next()) {
                MySqlCatalogTable table = new MySqlCatalogTable();
                table.setName(r.getString("Name"));
                if (typeStr != null) {
                    table.setTableType(r.getString(typeStr));
                }
                table.setAutoInc(r.getBoolean("Auto_increment"));
                tableList.add((Object)table);
            }
            this.tablesLoaded = true;
            r.close();
            s.close();
        }
        catch (Exception e) {
            MysqlPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wst.rdb.mysql", 0, "Could not load the tables for database " + this.getDatabase().getName(), (Throwable)e));
        }
        this.eSetDeliver(deliver);
    }
}

