/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.ProgressUtil;
import org.eclipse.wst.server.core.internal.Runtime;
import org.eclipse.wst.server.core.internal.RuntimeType;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.internal.WorkingCopyHelper;
import org.eclipse.wst.server.core.model.InternalInitializer;
import org.eclipse.wst.server.core.model.RuntimeDelegate;

public class RuntimeWorkingCopy
extends Runtime
implements IRuntimeWorkingCopy {
    protected String PROP_ID_SET = "id-set";
    protected Runtime runtime;
    protected WorkingCopyHelper wch;
    protected RuntimeDelegate workingCopyDelegate;

    public RuntimeWorkingCopy(Runtime runtime) {
        super(runtime.getFile());
        this.runtime = runtime;
        this.runtimeType = runtime.getRuntimeType();
        this.map = new HashMap(runtime.map);
        this.wch = new WorkingCopyHelper(this);
    }

    public RuntimeWorkingCopy(IFile file, String id, IRuntimeType runtimeType) {
        super(file, id, runtimeType);
        this.wch = new WorkingCopyHelper(this);
        this.wch.setDirty(true);
        if (id == null || id.length() == 0) {
            id = ServerPlugin.generateId();
            this.map.put("id", id);
        } else {
            this.setAttribute(this.PROP_ID_SET, true);
        }
    }

    public boolean isWorkingCopy() {
        return true;
    }

    public IRuntimeWorkingCopy createWorkingCopy() {
        return this;
    }

    public void setAttribute(String attributeName, int value) {
        this.wch.setAttribute(attributeName, value);
    }

    public void setAttribute(String attributeName, boolean value) {
        this.wch.setAttribute(attributeName, value);
    }

    public void setAttribute(String attributeName, String value) {
        this.wch.setAttribute(attributeName, value);
    }

    public void setAttribute(String attributeName, List value) {
        this.wch.setAttribute(attributeName, value);
    }

    public void setAttribute(String attributeName, Map value) {
        this.wch.setAttribute(attributeName, value);
    }

    public void setName(String name) {
        this.wch.setName(name);
        boolean set = this.getAttribute(this.PROP_ID_SET, false);
        if (this.runtime == null && !set) {
            this.setAttribute("id", name);
        }
    }

    public void setTestEnvironment(boolean b) {
        this.setAttribute("test-environment", b);
    }

    public void setStub(boolean b) {
        this.setAttribute("stub", b);
    }

    public boolean isDirty() {
        return this.wch.isDirty();
    }

    public IRuntime getOriginal() {
        return this.runtime;
    }

    public void setReadOnly(boolean b) {
        this.wch.setLocked(b);
    }

    public void setPrivate(boolean b) {
        this.wch.setPrivate(b);
    }

    public void setLocation(IPath path) {
        if (path == null) {
            this.setAttribute("location", (String)null);
        } else {
            this.setAttribute("location", path.toString());
        }
    }

    public IRuntime save(boolean force, IProgressMonitor monitor) throws CoreException {
        monitor = ProgressUtil.getMonitorFor(monitor);
        monitor.subTask(NLS.bind((String)Messages.savingTask, (Object)this.getName()));
        if (!force && this.getOriginal() != null) {
            this.wch.validateTimestamp(((Runtime)this.getOriginal()).getTimestamp());
        }
        Runtime origRuntime = this.runtime;
        if (this.runtime == null) {
            this.runtime = new Runtime(this.file);
        }
        String oldId = this.getId();
        String name = this.getName();
        boolean set = this.getAttribute(this.PROP_ID_SET, false);
        if (!oldId.equals(name) && !set) {
            this.setAttribute("id", name);
        } else {
            oldId = null;
        }
        this.runtime.setInternal(this);
        this.runtime.saveToMetadata(monitor);
        this.wch.setDirty(false);
        if (oldId != null) {
            this.updateRuntimeReferences(oldId, name, origRuntime);
        }
        return this.runtime;
    }

    protected void updateRuntimeReferences(String oldId, String newId, IRuntime origRuntime) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RuntimeDelegate getWorkingCopyDelegate(IProgressMonitor monitor) {
        if (this.workingCopyDelegate != null) {
            return this.workingCopyDelegate;
        }
        RuntimeWorkingCopy runtimeWorkingCopy = this;
        synchronized (runtimeWorkingCopy) {
            if (this.workingCopyDelegate == null) {
                try {
                    long time = System.currentTimeMillis();
                    this.workingCopyDelegate = ((RuntimeType)this.runtimeType).createRuntimeDelegate();
                    InternalInitializer.initializeRuntimeDelegate(this.workingCopyDelegate, this, monitor);
                    Trace.trace(Trace.PERFORMANCE, "RuntimeWorkingCopy.getWorkingCopyDelegate(): <" + (System.currentTimeMillis() - time) + "> " + this.getRuntimeType().getId());
                }
                catch (Exception e) {
                    Trace.trace(Trace.SEVERE, "Could not create delegate " + this.toString(), e);
                }
            }
        }
        return this.workingCopyDelegate;
    }

    public void dispose() {
        super.dispose();
        if (this.workingCopyDelegate != null) {
            this.workingCopyDelegate.dispose();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.wch.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.wch.removePropertyChangeListener(listener);
    }

    public void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        this.wch.firePropertyChangeEvent(propertyName, oldValue, newValue);
    }

    protected void setDefaults(IProgressMonitor monitor) {
        try {
            this.getWorkingCopyDelegate(monitor).setDefaults(monitor);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error calling delegate setDefaults() " + this.toString(), e);
        }
    }
}

