/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectValidator;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.internal.UnknownRuntime;

public final class BasicFacetedProjectValidator
implements IFacetedProjectValidator {
    public void validate(IFacetedProject fproj) throws CoreException {
        IRuntime r;
        Iterator itr1 = fproj.getTargetedRuntimes().iterator();
        while (itr1.hasNext()) {
            r = (IRuntime)itr1.next();
            if (!(r instanceof UnknownRuntime)) continue;
            String msg = NLS.bind((String)Resources.runtimeNotDefined, (Object)r.getName());
            fproj.createErrorMarker(msg);
        }
        itr1 = fproj.getTargetedRuntimes().iterator();
        while (itr1.hasNext()) {
            r = (IRuntime)itr1.next();
            Iterator itr2 = fproj.getProjectFacets().iterator();
            while (itr2.hasNext()) {
                IProjectFacetVersion fv = (IProjectFacetVersion)itr2.next();
                if (r.supports(fv)) continue;
                String msg = NLS.bind((String)Resources.facetNotSupported, (Object)fv.toString(), (Object)r.getName());
                fproj.createErrorMarker(msg);
            }
        }
        Iterator itr = fproj.getProjectFacets().iterator();
        while (itr.hasNext()) {
            String msg;
            IProjectFacetVersion fv = (IProjectFacetVersion)itr.next();
            IProjectFacet f = fv.getProjectFacet();
            if (f.getPluginId() == null) {
                msg = NLS.bind((String)Resources.facetNotFound, (Object)f.getId());
                fproj.createWarningMarker(msg);
                continue;
            }
            if (fv.getPluginId() != null) continue;
            msg = NLS.bind((String)Resources.facetVersionNotFound, (Object)f.getId(), (Object)fv.getVersionString());
            fproj.createWarningMarker(msg);
        }
    }

    private static final class Resources
    extends NLS {
        public static String runtimeNotDefined;
        public static String facetNotSupported;
        public static String facetNotFound;
        public static String facetVersionNotFound;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.BasicFacetedProjectValidator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.BasicFacetedProjectValidator$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }

        private Resources() {
        }
    }
}

