/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.provisional.jsfappconfig;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.Messages;
import org.eclipse.jst.jsf.core.internal.provisional.jsfappconfig.AbstractJSFAppConfigProvider;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigResourceFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.internal.emf.resource.EMF2SAXRendererFactory;
import org.eclipse.wst.common.internal.emf.resource.RendererFactory;

public class JARFileJSFAppConfigProvider
extends AbstractJSFAppConfigProvider {
    public static final String JARFILE_URI_PREFIX = "jar:file:///";
    public static final String FACES_CONFIG_IN_JAR_SUFFIX = "!/META-INF/faces-config.xml";
    protected String filename = null;
    protected FacesConfigType facesConfig = null;
    protected boolean loadErrorLogged = false;

    public JARFileJSFAppConfigProvider(String filename) {
        this.filename = filename;
    }

    public FacesConfigType getFacesConfigModel() {
        if (this.facesConfig == null && this.filename != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(JARFILE_URI_PREFIX);
            sb.append(this.filename);
            sb.append(FACES_CONFIG_IN_JAR_SUFFIX);
            URI jarFileURI = URI.createURI((String)sb.toString());
            FacesConfigResourceFactory resourceFactory = new FacesConfigResourceFactory((RendererFactory)EMF2SAXRendererFactory.INSTANCE);
            Resource resource = resourceFactory.createResource(jarFileURI);
            try {
                EList resourceContents;
                resource.load(Collections.EMPTY_MAP);
                if (resource != null && (resourceContents = resource.getContents()) != null && resourceContents.size() > 0) {
                    this.facesConfig = (FacesConfigType)resourceContents.get(0);
                    if (this.facesConfig != null) {
                        this.jsfAppConfigLocater.getJSFAppConfigManager().addFacesConfigChangeAdapter(this.facesConfig);
                    }
                }
            }
            catch (IllegalStateException ise) {
                this.logLoadError(ise);
            }
            catch (IOException ioe) {
                this.logLoadError(ioe);
            }
        }
        return this.facesConfig;
    }

    public void releaseFacesConfigModel() {
        this.jsfAppConfigLocater.getJSFAppConfigManager().removeFacesConfigChangeAdapter(this.facesConfig);
    }

    protected void logLoadError(Throwable ex) {
        if (!this.loadErrorLogged) {
            JSFCorePlugin.log(4, NLS.bind((String)Messages.JARFileJSFAppConfigProvider_ErrorLoadingModel, (Object)(JARFILE_URI_PREFIX + this.filename + FACES_CONFIG_IN_JAR_SUFFIX)), ex);
            this.loadErrorLogged = true;
        }
    }

    public boolean equals(Object otherObject) {
        boolean equals = false;
        if (otherObject != null && otherObject instanceof JARFileJSFAppConfigProvider) {
            String otherFilename = ((JARFileJSFAppConfigProvider)otherObject).filename;
            equals = this.filename != null ? this.filename.equals(otherFilename) : otherFilename == null;
        }
        return equals;
    }

    public int hashCode() {
        return this.filename != null ? this.filename.hashCode() : 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("JARFileJSFAppConfigProvider[");
        if (this.filename != null) {
            sb.append(this.filename);
        } else {
            sb.append("null");
        }
        sb.append("]");
        return sb.toString();
    }
}

