/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el.operators;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.core.internal.types.BooleanLiteralType;
import org.eclipse.jst.jsf.core.internal.types.LiteralType;
import org.eclipse.jst.jsf.core.internal.types.TypeCoercer;
import org.eclipse.jst.jsf.core.internal.types.TypeCoercionException;
import org.eclipse.jst.jsf.core.internal.types.TypeTransformer;
import org.eclipse.jst.jsf.core.internal.types.ValueType;
import org.eclipse.jst.jsf.validation.el.operators.DiagnosticFactory;
import org.eclipse.jst.jsf.validation.el.operators.UnaryOperator;

class NotUnaryOperator
extends UnaryOperator {
    NotUnaryOperator() {
    }

    public Diagnostic validate(ValueType type) {
        boolean canCoerce = TypeCoercer.canCoerceToBoolean((String)TypeTransformer.transformBoxPrimitives((String)type.getSignature()));
        if (canCoerce) {
            return Diagnostic.OK_INSTANCE;
        }
        return DiagnosticFactory.create_UNARY_OP_CANNOT_COERCE_ARGUMENT_TO_BOOLEAN();
    }

    public ValueType performOperation(ValueType type) {
        boolean canCoerce = TypeCoercer.canCoerceToBoolean((String)TypeTransformer.transformBoxPrimitives((String)type.getSignature()));
        if (canCoerce) {
            if (type instanceof LiteralType) {
                try {
                    Boolean coercedValue = ((LiteralType)type).coerceToBoolean();
                    return coercedValue != false ? BooleanLiteralType.FALSE : BooleanLiteralType.TRUE;
                }
                catch (TypeCoercionException typeCoercionException) {
                    throw new AssertionError((Object)"coerce should not throw exception");
                }
            }
            return new ValueType("Z", type.getAssignability());
        }
        return null;
    }
}

