/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.command;

import org.eclipse.jst.jsf.facesconfig.ui.pageflow.command.ConnectionCommand;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.util.PageflowValidation;

public class ReconnectConnectionCommand
extends ConnectionCommand {
    public boolean canExecute() {
        if (this.link == null || this.link.eContainer() == null) {
            return false;
        }
        if (this.oldSource != null && this.pageflowNode != null && this.oldTarget != null && this.target != null && !PageflowValidation.getInstance().isValidLinkForCreation(this.pageflowNode, this.target)) {
            return false;
        }
        if (this.oldSource != null && this.pageflowNode != null && !PageflowValidation.getInstance().isValidLinkForCreation(this.pageflowNode, this.oldTarget)) {
            return false;
        }
        return this.oldTarget == null || this.target == null || PageflowValidation.getInstance().isValidLinkForCreation(this.oldSource, this.target);
    }

    public void doExecute() {
        if (this.oldSource != null && this.pageflowNode != null) {
            this.link.setSource(this.pageflowNode);
        }
        if (this.oldTarget != null && this.target != null) {
            this.link.setTarget(this.target);
        }
    }

    public void undo() {
        if (this.canExecute()) {
            if (this.oldSource != null && this.pageflowNode != null) {
                if (this.link.getSource() != null) {
                    this.link.getSource().getOutlinks().remove((Object)this.link);
                }
                this.pageflowNode.getOutlinks().remove((Object)this.link);
                this.link.setSource(this.oldSource);
            }
            if (this.oldTarget != null && this.target != null) {
                if (this.link.getTarget() != null) {
                    this.link.getTarget().getInlinks().remove((Object)this.link);
                }
                this.target.getInlinks().remove((Object)this.link);
                this.link.setTarget(this.oldTarget);
            }
        }
    }
}

