/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.command;

import org.eclipse.gef.commands.Command;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.PageflowMessages;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowLink;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowNode;

public abstract class ConnectionCommand
extends Command {
    protected PageflowNode oldSource;
    protected PageflowNode oldTarget;
    protected PageflowNode pageflowNode;
    protected PageflowNode target;
    protected PageflowLink link;

    public ConnectionCommand() {
        super(PageflowMessages.Pageflow_Commands_ConnectionCommand_Label);
    }

    public boolean canExecute() {
        return false;
    }

    protected void doExecute() {
    }

    public final void execute() {
        if (this.canExecute()) {
            String outcome = null;
            String action = null;
            String largeIcon = null;
            String smallIcon = null;
            boolean isRedirect = false;
            if (this.link != null) {
                outcome = this.link.getOutcome();
                action = this.link.getFromaction();
                isRedirect = this.link.isRedirect();
                largeIcon = this.link.getLargeicon();
                smallIcon = this.link.getSmallicon();
            }
            this.doExecute();
            if (this.link != null) {
                this.link.setOutcome(outcome);
                this.link.setFromaction(action);
                this.link.setLargeicon(largeIcon);
                this.link.setSmallicon(smallIcon);
                this.link.setRedirect(isRedirect);
            }
        } else {
            this.link = null;
        }
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
    }

    public PageflowNode getSource() {
        return this.pageflowNode;
    }

    public PageflowNode getTarget() {
        return this.target;
    }

    public PageflowLink getPFLink() {
        return this.link;
    }

    public void setSource(PageflowNode newSource) {
        this.pageflowNode = newSource;
    }

    public void setTarget(PageflowNode newTarget) {
        this.target = newTarget;
    }

    public void setPFLink(PageflowLink link) {
        this.link = link;
        this.oldSource = link.getSource();
        this.oldTarget = link.getTarget();
    }
}

