/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.dialog;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.ClassButtonDialogField;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.DialogFieldBase;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.LayoutUtil;
import org.eclipse.jst.jsf.facesconfig.common.guiutils.SWTUtils;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.KeyClassType;
import org.eclipse.jst.jsf.facesconfig.emf.KeyType;
import org.eclipse.jst.jsf.facesconfig.emf.MapEntriesType;
import org.eclipse.jst.jsf.facesconfig.emf.MapEntryType;
import org.eclipse.jst.jsf.facesconfig.emf.NullValueType;
import org.eclipse.jst.jsf.facesconfig.emf.ValueClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ValueType;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.NewEditorResourcesNLS;
import org.eclipse.jst.jsf.facesconfig.ui.dialog.AddEditMapEntryDialog;
import org.eclipse.jst.jsf.facesconfig.ui.section.AbstractFacesConfigSection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.editor.FormEditor;

public class EditMapEntriesDialog
extends Dialog {
    private static final int MIN_DIALOG_WIDTH = 300;
    private static final int TABLE_DEFAULT_HEIGHT = 160;
    private ClassButtonDialogField keyClassField;
    private ClassButtonDialogField valueClassField;
    private IProject project;
    private TableViewer tableViewer;
    private Button removeButton;
    private Button editButton;
    private MapEntriesType mapEntries;
    private AbstractFacesConfigSection section;
    static /* synthetic */ Class class$0;

    public EditMapEntriesDialog(Shell parentShell, MapEntriesType mapEntries, AbstractFacesConfigSection section) {
        super(parentShell);
        this.mapEntries = mapEntries;
        this.section = section;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Editing map-entries");
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 4);
        GridData data = new GridData(1808);
        container.setLayoutData((Object)data);
        GridLayout gl = new GridLayout();
        gl.verticalSpacing = 0;
        container.setLayout((Layout)gl);
        this.createKeyValueSection(container);
        this.createTableSection(container);
        this.initFields();
        return container;
    }

    private void initFields() {
        if (this.mapEntries.getKeyClass() != null) {
            this.keyClassField.setText(this.mapEntries.getKeyClass().getTextContent());
        }
        if (this.mapEntries.getValueClass() != null) {
            this.valueClassField.setText(this.mapEntries.getValueClass().getTextContent());
        }
        this.tableViewer.setInput((Object)this.mapEntries);
    }

    private void createKeyValueSection(Composite parent) {
        this.keyClassField = new ClassButtonDialogField(this.getProject());
        this.keyClassField.setLabelText(NewEditorResourcesNLS.InitializationSection_MapType_KeyClass);
        this.valueClassField = new ClassButtonDialogField(this.getProject());
        this.valueClassField.setLabelText(NewEditorResourcesNLS.InitializationSection_MapType_ValueClass);
        Composite typeSelectionSection = SWTUtils.createComposite((Composite)parent, (int)0);
        GridData gd = new GridData(768);
        typeSelectionSection.setLayoutData((Object)gd);
        int numberOfColumns = 4;
        GridLayout gl = new GridLayout(numberOfColumns, false);
        typeSelectionSection.setLayout((Layout)gl);
        this.keyClassField.doFillIntoGrid(null, typeSelectionSection, numberOfColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.keyClassField.getTextControl(null, parent));
        this.valueClassField.doFillIntoGrid(null, typeSelectionSection, numberOfColumns);
    }

    private void createTableSection(Composite parent) {
        Composite mapValueSection = SWTUtils.createComposite((Composite)parent, (int)0);
        GridData gd = new GridData(1808);
        mapValueSection.setLayoutData((Object)gd);
        int numberOfColumns = 3;
        GridLayout gl = new GridLayout(numberOfColumns, false);
        mapValueSection.setLayout((Layout)gl);
        DialogFieldBase valuesTitle = new DialogFieldBase();
        valuesTitle.setLabelText(NewEditorResourcesNLS.InitializationSection_MapTable_Title);
        valuesTitle.doFillIntoGrid(null, mapValueSection, numberOfColumns);
        Table mapTable = new Table(mapValueSection, 68352);
        mapTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditMapEntriesDialog.this.updateButtonsStatus();
            }
        });
        mapTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (((IStructuredSelection)EditMapEntriesDialog.this.tableViewer.getSelection()).size() > 0) {
                    EditMapEntriesDialog.this.editButtonSelected(null);
                }
            }
        });
        gd = new GridData(1808);
        gd.horizontalSpan = 1;
        gd.heightHint = 160;
        mapTable.setLayoutData((Object)gd);
        mapTable.setHeaderVisible(true);
        mapTable.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        mapTable.setLayout((Layout)layout);
        TableColumn keyCol = new TableColumn(mapTable, 0);
        keyCol.setText(NewEditorResourcesNLS.InitializationSection_MapTable_Key);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        keyCol.setResizable(true);
        TableColumn valueCol = new TableColumn(mapTable, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        valueCol.setText(NewEditorResourcesNLS.InitializationSection_MapTable_Value);
        valueCol.setResizable(true);
        this.tableViewer = new TableViewer(mapTable);
        this.tableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.getAdapterFactory()));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.getAdapterFactory()));
        this.tableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return FacesConfigPackage.eINSTANCE.getMapEntryType().isInstance(element);
            }
        });
        Composite operationContainer = null;
        operationContainer = SWTUtils.createComposite((Composite)mapValueSection, (int)0);
        gd = new GridData(1040);
        operationContainer.setLayoutData((Object)gd);
        gl = new GridLayout();
        operationContainer.setLayout((Layout)gl);
        Button addButton = SWTUtils.createPushButton((Composite)operationContainer, (String)NewEditorResourcesNLS.UI_Button_Add_more);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        addButton.setLayoutData((Object)gd);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditMapEntriesDialog.this.addButtonSelected(e);
            }
        });
        this.editButton = SWTUtils.createPushButton((Composite)operationContainer, (String)NewEditorResourcesNLS.UI_Button_Edit_more);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.editButton.setLayoutData((Object)gd);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditMapEntriesDialog.this.editButtonSelected(e);
            }
        });
        this.removeButton = SWTUtils.createPushButton((Composite)operationContainer, (String)NewEditorResourcesNLS.UI_Button_Remove);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.removeButton.setLayoutData((Object)gd);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditMapEntriesDialog.this.removeButtonSelected();
            }
        });
        this.editButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    public IProject getProject() {
        if (this.project == null) {
            FormEditor formEditor = this.section.getPage().getEditor();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.project = (IProject)formEditor.getAdapter((Class)clazz);
        }
        return this.project;
    }

    private AdapterFactory getAdapterFactory() {
        return this.section.getAdapterFactory();
    }

    private void addButtonSelected(SelectionEvent e) {
        AddEditMapEntryDialog dialog = new AddEditMapEntryDialog(EditorPlugin.getActiveShell(), true);
        if (dialog.open() == 0) {
            MapEntryType mapEntry = FacesConfigFactory.eINSTANCE.createMapEntryType();
            if (dialog.getKey() != null) {
                KeyType key = FacesConfigFactory.eINSTANCE.createKeyType();
                key.setTextContent(dialog.getKey());
                mapEntry.setKey(key);
            }
            if (dialog.isNullValue()) {
                NullValueType nullValue = FacesConfigFactory.eINSTANCE.createNullValueType();
                mapEntry.setNullValue(nullValue);
            } else {
                ValueType value = FacesConfigFactory.eINSTANCE.createValueType();
                value.setTextContent(dialog.getValue());
                mapEntry.setValue(value);
            }
            this.mapEntries.getMapEntry().add((Object)mapEntry);
        }
    }

    private void editButtonSelected(SelectionEvent e) {
        MapEntryType mapEntry = (MapEntryType)((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
        AddEditMapEntryDialog dialog = new AddEditMapEntryDialog(EditorPlugin.getActiveShell(), false);
        if (mapEntry.getKey() != null) {
            dialog.setKey(mapEntry.getKey().getTextContent());
        }
        if (mapEntry.getNullValue() != null) {
            dialog.setNullValue(true);
        } else if (mapEntry.getValue() != null) {
            dialog.setValue(mapEntry.getValue().getTextContent());
        }
        if (dialog.open() == 0) {
            if (mapEntry.getKey() != null) {
                mapEntry.getKey().setTextContent(dialog.getKey());
            } else {
                KeyType keyType = FacesConfigFactory.eINSTANCE.createKeyType();
                keyType.setTextContent(dialog.getKey());
                mapEntry.setKey(keyType);
            }
            if (dialog.isNullValue()) {
                if (mapEntry.getValue() != null) {
                    EcoreUtil.remove((EObject)mapEntry.getValue());
                }
                mapEntry.setNullValue(FacesConfigFactory.eINSTANCE.createNullValueType());
            } else {
                if (mapEntry.getNullValue() != null) {
                    EcoreUtil.remove((EObject)mapEntry.getNullValue());
                }
                if (mapEntry.getValue() != null) {
                    mapEntry.getValue().setTextContent(dialog.getValue());
                } else {
                    ValueType value = FacesConfigFactory.eINSTANCE.createValueType();
                    value.setTextContent(dialog.getValue());
                    mapEntry.setValue(value);
                }
            }
            this.tableViewer.refresh((Object)mapEntry);
        }
    }

    private void removeButtonSelected() {
        MapEntryType mapEntry = (MapEntryType)((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
        this.mapEntries.getMapEntry().remove((Object)mapEntry);
        this.tableViewer.refresh();
        this.updateButtonsStatus();
    }

    public void updateButtonsStatus() {
        if (((IStructuredSelection)this.tableViewer.getSelection()).size() > 0) {
            this.editButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    protected void okPressed() {
        KeyClassType keyClass = FacesConfigFactory.eINSTANCE.createKeyClassType();
        keyClass.setTextContent(this.keyClassField.getText().trim());
        this.mapEntries.setKeyClass(keyClass);
        ValueClassType valueClass = FacesConfigFactory.eINSTANCE.createValueClassType();
        valueClass.setTextContent(this.valueClassField.getText().trim());
        this.mapEntries.setValueClass(valueClass);
        super.okPressed();
    }

    protected Point getInitialSize() {
        Point shellSize = super.getInitialSize();
        return new Point(Math.max(this.convertHorizontalDLUsToPixels(300), shellSize.x), shellSize.y);
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public MapEntriesType getMapEntries() {
        return this.mapEntries;
    }

    public void setMapEntries(MapEntriesType mapEntries) {
        this.mapEntries = mapEntries;
    }
}

