/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.dialog;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.ClassButtonDialogField;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.LayoutUtil;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.StringDialogField;
import org.eclipse.jst.jsf.facesconfig.ui.NewEditorResourcesNLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class AddEditAttributeDialog
extends Dialog {
    private static final int MIN_DIALOG_WIDTH = 300;
    private StringDialogField attributeNameField;
    private ClassButtonDialogField attributeClassField;
    private StringDialogField defaultValueField;
    private StringDialogField suggestedValueField;
    private IProject project;
    private String attributeName;
    private String attributeClass;
    private String defaultValue;
    private String suggestedValue;
    private boolean isNew;

    public AddEditAttributeDialog(Shell parentShell, boolean isNew) {
        super(parentShell);
        this.isNew = isNew;
    }

    public AddEditAttributeDialog(Shell parentShell, String attributeName, String attributeClass, String defaultValue, String suggestedValue) {
        super(parentShell);
        this.attributeName = attributeName;
        this.attributeClass = attributeClass;
        this.defaultValue = defaultValue;
        this.suggestedValue = suggestedValue;
        this.isNew = false;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.isNew) {
            newShell.setText(NewEditorResourcesNLS.AttributeSection_Dialog_Title_Add);
        } else {
            newShell.setText(NewEditorResourcesNLS.AttributeSection_Dialog_Title_Edit);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 4);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        TabFolder tabFolder = new TabFolder(container, 4);
        tabFolder.setLayoutData((Object)gd);
        TabItem generalTabItem = new TabItem(tabFolder, 0);
        generalTabItem.setText(NewEditorResourcesNLS.AttributeSection_Dialog_Tab_General);
        Control control = this.createGeneralTabControl((Composite)generalTabItem.getParent());
        generalTabItem.setControl(control);
        return container;
    }

    private Control createGeneralTabControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        composite.setFont(parent.getFont());
        this.attributeNameField = new StringDialogField();
        this.attributeNameField.setLabelText(NewEditorResourcesNLS.AttributeSection_Dialog_AttributeName);
        this.attributeClassField = new ClassButtonDialogField(this.getProject());
        this.attributeClassField.setLabelText(NewEditorResourcesNLS.AttributeSection_Dialog_AttributeClass);
        this.attributeClassField.setAutoOpenResource(false);
        this.defaultValueField = new StringDialogField();
        this.defaultValueField.setLabelText(NewEditorResourcesNLS.AttributeSection_Dialog_DefaultValue);
        this.suggestedValueField = new StringDialogField();
        this.suggestedValueField.setLabelText(NewEditorResourcesNLS.AttributeSection_Dialog_SuggestedValue);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        int numberOfColumns = 4;
        GridLayout gl = new GridLayout(numberOfColumns, false);
        composite.setLayout((Layout)gl);
        this.attributeNameField.doFillIntoGrid(null, composite, numberOfColumns);
        this.attributeClassField.doFillIntoGrid(null, composite, numberOfColumns);
        this.defaultValueField.doFillIntoGrid(null, composite, numberOfColumns);
        this.suggestedValueField.doFillIntoGrid(null, composite, numberOfColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.attributeClassField.getTextControl(null, composite));
        this.attributeNameField.setText(this.attributeName);
        this.attributeClassField.setText(this.attributeClass);
        this.defaultValueField.setText(this.defaultValue);
        this.suggestedValueField.setText(this.suggestedValue);
        return composite;
    }

    protected Point getInitialSize() {
        Point shellSize = super.getInitialSize();
        return new Point(Math.max(this.convertHorizontalDLUsToPixels(300), shellSize.x), shellSize.y);
    }

    public IProject getProject() {
        return this.project;
    }

    protected void okPressed() {
        this.attributeName = this.attributeNameField.getText();
        this.attributeClass = this.attributeClassField.getText();
        this.defaultValue = this.defaultValueField.getText();
        this.suggestedValue = this.suggestedValueField.getText();
        super.okPressed();
    }

    public String getAttributeClass() {
        return this.attributeClass;
    }

    public void setAttributeClass(String attributeClass) {
        this.attributeClass = attributeClass;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getSuggestedValue() {
        return this.suggestedValue;
    }

    public void setSuggestedValue(String suggestedValue) {
        this.suggestedValue = suggestedValue;
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

