/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.common.utils;

import java.io.File;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wtp.jsf.facesconfig.editor.common.CommonPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.common.utils.WebrootUtil;

public class PathUtil {
    public static final String BACKWARD_SLASH = "\\";
    public static final String FORWARD_SLASH = "/";
    public static final String RELATIVE_PATH_SIGNAL = "../";

    public static String adjustRelativePath(String path) {
        int i = 0;
        while ((i = path.indexOf(RELATIVE_PATH_SIGNAL)) > 0) {
            String part1 = path.substring(0, i - 1);
            String part2 = path.substring(i + RELATIVE_PATH_SIGNAL.length() - 1);
            int j = part1.lastIndexOf(FORWARD_SLASH);
            if (j == -1) {
                return "";
            }
            part1 = part1.substring(0, j);
            path = String.valueOf(part1) + part2;
        }
        return path;
    }

    public static String appendTrailingURLSlash(String input) {
        if (!input.endsWith(FORWARD_SLASH)) {
            input = String.valueOf(input) + FORWARD_SLASH;
        }
        return input;
    }

    public static String convertToRelativePath(String input, String base) {
        StringTokenizer inputTokenizer = new StringTokenizer(input, FORWARD_SLASH);
        StringTokenizer baseTokenizer = new StringTokenizer(base, FORWARD_SLASH);
        String token1 = "";
        String token2 = "";
        while (inputTokenizer.hasMoreTokens() && baseTokenizer.hasMoreTokens() && (token1 = baseTokenizer.nextToken()).equals(token2 = inputTokenizer.nextToken())) {
        }
        String output = "";
        while (baseTokenizer.hasMoreTokens()) {
            baseTokenizer.nextToken();
            output = String.valueOf(output) + RELATIVE_PATH_SIGNAL;
        }
        output = String.valueOf(output) + token2;
        while (inputTokenizer.hasMoreTokens()) {
            output = String.valueOf(output) + FORWARD_SLASH + inputTokenizer.nextToken();
        }
        return output;
    }

    public static String convertToWebPath(IPath path) {
        return WebrootUtil.getWebPath(path);
    }

    public static String convertToAbsolutePath(String uri, IFile curFile) {
        IPath path;
        IContainer con;
        if (uri == null || uri.trim().equals("")) {
            return uri;
        }
        String webroot = "";
        IFile jsp = curFile;
        try {
            if (jsp == null) {
                jsp = ((IFileEditorInput)CommonPlugin.getActivePage().getActiveEditor().getEditorInput()).getFile();
            }
            if (jsp != null) {
                webroot = WebrootUtil.getWebContentPath(jsp.getProject()).toString();
            }
        }
        catch (NullPointerException nullPointerException) {
            return uri;
        }
        if (uri.startsWith(FORWARD_SLASH)) {
            return String.valueOf(webroot) + uri;
        }
        if (jsp != null && (con = jsp.getParent()) != null && (path = con.getLocation()) != null) {
            File file;
            String aPath = String.valueOf(path.toString()) + File.separator + uri;
            aPath = aPath.replace('/', File.separatorChar);
            if ((aPath = aPath.replace('\\', File.separatorChar)).endsWith(File.separator)) {
                aPath = String.valueOf(aPath) + FORWARD_SLASH;
            }
            if ((file = new File(aPath)).exists() && file.isFile()) {
                return file.getAbsolutePath();
            }
            return uri;
        }
        return uri;
    }

    /*
     * Unable to fully structure code
     */
    public static IPath getPathOnClasspath(IJavaProject javaProject, Object parent) {
        result = null;
        if (javaProject == null || parent == null) {
            return new Path("");
        }
        entries = javaProject.readRawClasspath();
        classPath = null;
        if (parent instanceof IResource) {
            if (javaProject != null && !javaProject.isOnClasspath((IResource)parent)) {
                return new Path("");
            }
            if (parent instanceof IFile) {
                elementPath = ((IFile)parent).getFullPath();
                if (((IFile)parent).getFileExtension().equalsIgnoreCase("properties")) {
                    block14: {
                        machings = 0;
                        try {
                            i = 0;
                            while (i < entries.length) {
                                n = entries[i].getPath().matchingFirstSegments(elementPath);
                                if (n > machings) {
                                    machings = n;
                                    classPath = elementPath.removeFirstSegments(machings).removeLastSegments(1);
                                }
                                ++i;
                            }
                            if (classPath != null) break block14;
                            return null;
                        }
                        catch (Exception v0) {
                            return null;
                        }
                    }
                    if (classPath.segmentCount() > 0) {
                        element = javaProject.findElement(classPath);
                        if (element == null || (path = element.getPath()) == null) ** GOTO lbl41
                        path1 = path.removeFirstSegments(machings);
                        fileName = ((IFile)parent).getName();
                        if (fileName == null) ** GOTO lbl41
                        result = path1.append(fileName);
                    }
                    result = ((IFile)parent).getFullPath().removeFirstSegments(machings);
                }
            }
        } else if (parent instanceof JarEntryFile && (elementPath = ((JarEntryFile)parent).getFullPath()).getFileExtension().equalsIgnoreCase("properties")) {
            result = elementPath;
        }
lbl41:
        // 8 sources

        if (result != null) {
            return result;
        }
        return new Path("");
    }
}

