/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.wtp.jsf.facesconfig.editor.common.CommonPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogFieldResources;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.IStringButtonAdapter;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StatusInfo;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StringButtonDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.TypedElementSelectionValidator;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.TypedViewerFilter;
import org.eclipse.wtp.jsf.facesconfig.editor.common.logging.Logger;

public class SourceFolderButtonDialogField
extends StringButtonDialogField {
    private static Logger log;
    private IPackageFragmentRoot fCurrRoot;
    private IProject project;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.SourceFolderButtonDialogField");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = CommonPlugin.getLogger(clazz);
    }

    public SourceFolderButtonDialogField(IProject project) {
        super(null);
        this.project = project;
        this.setLabelText(DialogFieldResources.getInstance().getString("SourceFolderButtonDialogField.container.label"));
        this.setButtonLabel(DialogFieldResources.getInstance().getString("SourceFolderButtonDialogField.container.button"));
        this.setStringButtonAdapter(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                SourceFolderButtonDialogField.this.containerChangeControlPressed(field);
            }
        });
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    protected void containerChangeControlPressed(DialogField field) {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if ((root = this.chooseSourceContainer((IJavaElement)root)) != null) {
            this.setPackageFragmentRoot(root, true);
        }
    }

    public void setPackageFragmentRoot(IPackageFragmentRoot root, boolean canBeModified) {
        this.fCurrRoot = root;
        String str = root == null ? "" : root.getPath().makeRelative().toString();
        this.setText(str);
        this.setEnabled(canBeModified);
    }

    public IPackageFragmentRoot getPackageFragmentRoot() {
        return this.fCurrRoot;
    }

    public String getPackageFragmentRootText() {
        return this.getText();
    }

    private IPackageFragmentRoot chooseSourceContainer(IJavaElement initElement) {
        Class[] classArray = new Class[2];
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jdt.core.IPackageFragmentRoot");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.jdt.core.IJavaProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class[] acceptedClasses = classArray;
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false){

            public boolean isSelectedValid(Object element) {
                try {
                    if (element instanceof IJavaProject) {
                        IJavaProject jproject = (IJavaProject)element;
                        IPath path = jproject.getProject().getFullPath();
                        return jproject.findPackageFragmentRoot(path) != null;
                    }
                    if (element instanceof IPackageFragmentRoot) {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    return true;
                }
                catch (JavaModelException e) {
                    log.error(e);
                    return false;
                }
            }
        };
        Class[] classArray2 = new Class[3];
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.eclipse.jdt.core.IJavaModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[0] = clazz3;
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("org.eclipse.jdt.core.IPackageFragmentRoot");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[1] = clazz4;
        Class<?> clazz5 = class$2;
        if (clazz5 == null) {
            try {
                clazz5 = class$2 = Class.forName("org.eclipse.jdt.core.IJavaProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[2] = clazz5;
        acceptedClasses = classArray2;
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IPackageFragmentRoot) {
                    try {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    catch (JavaModelException e) {
                        log.error(e);
                        return false;
                    }
                }
                return super.select(viewer, parent, element);
            }
        };
        StandardJavaElementContentProvider provider = new StandardJavaElementContentProvider();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setSorter((ViewerSorter)new JavaElementSorter());
        dialog.setTitle(DialogFieldResources.getInstance().getString("SourceFolderButtonDialogField.ChooseSourceContainerDialog.Title"));
        dialog.setMessage(DialogFieldResources.getInstance().getString("SourceFolderButtonDialogField.ChooseSourceContainerDialog.Description"));
        dialog.addFilter((ViewerFilter)filter);
        if (this.project != null) {
            dialog.setInput((Object)JavaCore.create((IProject)this.project));
        } else {
            dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        }
        dialog.setInitialSelection((Object)initElement);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            if (element instanceof IJavaProject) {
                IJavaProject jproject = (IJavaProject)element;
                return jproject.getPackageFragmentRoot((IResource)jproject.getProject());
            }
            if (element instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)element;
            }
            return null;
        }
        return null;
    }

    public IStatus getChangedStatus() {
        StatusInfo status = new StatusInfo();
        this.fCurrRoot = null;
        String str = this.getPackageFragmentRootText();
        if (str.length() == 0) {
            status.setError(DialogFieldResources.getInstance().getString("SourceFolderButtonDialogField.error.EnterContainerName"));
            return status;
        }
        Path path = new Path(str);
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
        if (res != null) {
            int resType = res.getType();
            if (resType == 4 || resType == 2) {
                IProject proj = res.getProject();
                if (!proj.isOpen()) {
                    status.setError(DialogFieldResources.getInstance().getString("SourceFolderButtonDialogField.error.ProjectClosed", proj.getFullPath().toString()));
                    return status;
                }
                if (this.project != null && proj != this.project) {
                    status.setError(DialogFieldResources.getInstance().getString("SourceFolderButtonDialogField.error.NotSameProject", this.project.getName()));
                    return status;
                }
                IJavaProject jproject = JavaCore.create((IProject)proj);
                this.fCurrRoot = jproject.getPackageFragmentRoot(res);
                if (res.exists()) {
                    try {
                        if (!proj.hasNature("org.eclipse.jdt.core.javanature")) {
                            if (resType == 4) {
                                status.setError(DialogFieldResources.getInstance().getString("SourceFolderButtonDialogField.warning.NotAJavaProject", proj.getName()));
                            } else {
                                status.setWarning(DialogFieldResources.getInstance().getString("SourceFolderButtonDialogField.warning.NotInAJavaProject", proj.getName()));
                            }
                            return status;
                        }
                    }
                    catch (CoreException coreException) {
                        status.setWarning(DialogFieldResources.getInstance().getString("SourceFolderButtonDialogField.warning.NotAJavaProject", proj.getName()));
                    }
                    if (!jproject.isOnClasspath((IJavaElement)this.fCurrRoot)) {
                        status.setWarning(DialogFieldResources.getInstance().getString("SourceFolderButtonDialogField.warning.NotOnClassPath", str));
                    }
                    if (this.fCurrRoot.isArchive()) {
                        status.setError(DialogFieldResources.getInstance().getString("SourceFolderButtonDialogField.error.ContainerIsBinary", str));
                        return status;
                    }
                }
                return status;
            }
            status.setError(DialogFieldResources.getInstance().getString("SourceFolderButtonDialogField.error.NotAFolder", str));
            return status;
        }
        status.setError(DialogFieldResources.getInstance().getString("SourceFolderButtonDialogField.error.ContainerDoesNotExist", str));
        return status;
    }
}

