/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.wtp.jsf.facesconfig.editor.common.CommonPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.IStringButtonAdapter;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.JavaClassWizard;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.JavaUIHelper;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StringButtonDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.guiutils.Alerts;

public abstract class AbstractClassButtonDialogField
extends StringButtonDialogField {
    private IProject project;
    private String superClass;
    private List interfacesList;
    private IType type;
    private int typeFlag = 256;
    private boolean autoOpenResource = true;

    public void setAutoOpenResource(boolean autoOpenResource) {
        this.autoOpenResource = autoOpenResource;
    }

    public AbstractClassButtonDialogField(IProject project) {
        super(null);
        this.project = project;
        this.setHyperLink((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AbstractClassButtonDialogField.this.activeLink();
            }
        });
        this.setStringButtonAdapter(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                AbstractClassButtonDialogField.this.browseButtonPressed();
            }
        });
    }

    private void activeLink() {
        String className = this.getText();
        if ((className = this.trimNonAlphaChars(className)).length() > 0 && JavaUIHelper.doesClassExist(this.project, className)) {
            JavaUIHelper.doOpenClass(this.project, className);
        } else {
            String newValue;
            try {
                if (this.project == null || !this.project.hasNature("org.eclipse.jdt.core.javanature")) {
                    ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogFieldResources");
                    Alerts alerts = new Alerts(CommonPlugin.getDefault(), rb);
                    alerts.error("ClassButtonDialogField.Alert.Title", "ClassButtonDialogField.Alert.Msg");
                    return;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
                return;
            }
            JavaClassWizard wizard = new JavaClassWizard(this.project, className, this.superClass, this.getImplementInterfaces());
            wizard.setAutoOpenResource(this.autoOpenResource);
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            dialog.create();
            this.setDialogSize((Dialog)dialog, 400, 500);
            if (dialog.open() == 0 && !(newValue = wizard.getClassNameWithArgs()).equals(className)) {
                this.setText(newValue);
            }
        }
    }

    protected abstract List getImplementInterfaces();

    protected abstract IJavaSearchScope getJavaSearchScope();

    private void browseButtonPressed() {
        Shell shell = this.getShell();
        SelectionDialog dialog = JavaUIHelper.openSelectionDialog(shell, this.getJavaSearchScope(), this.typeFlag);
        dialog.setTitle(CommonPlugin.getResourceString("DialogField.ClassButton.SelectType"));
        if (dialog.open() == 0) {
            String oldClassName = this.getText();
            if (dialog.getResult() != null) {
                this.type = (IType)dialog.getResult()[0];
                String newClassName = this.type.getFullyQualifiedName();
                if (!oldClassName.equals(newClassName)) {
                    this.setText(newClassName);
                }
            }
        }
    }

    private void setDialogSize(Dialog dialog, int width, int height) {
        Point computedSize = dialog.getShell().computeSize(-1, -1);
        width = Math.max(computedSize.x, width);
        height = Math.max(computedSize.y, height);
        dialog.getShell().setSize(width, height);
    }

    private String trimNonAlphaChars(String className) {
        className = className.trim();
        while (className.length() > 0 && !Character.isLetter(className.charAt(0))) {
            className = className.substring(1, className.length());
        }
        int loc = className.indexOf(":");
        if (loc != -1 && loc > 0) {
            className = className.substring(0, loc);
        } else if (loc == 0) {
            className = "";
        }
        return className;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public String getSuperClassName() {
        return this.superClass;
    }

    public void setSuperClassName(String superClassName) {
        this.superClass = superClassName;
    }

    protected List getInterfacesList() {
        return this.interfacesList;
    }

    public void setInterface(String interfaceName) {
        this.interfacesList = new ArrayList();
        this.interfacesList.add(interfaceName);
    }

    public void setInterfacesList(List interfacesList) {
        this.interfacesList = interfacesList;
    }

    public IType getType() {
        return this.type;
    }

    public int getTypeFlag() {
        return this.typeFlag;
    }

    public void setTypeFlag(int typeFalg) {
        this.typeFlag = typeFalg;
    }
}

