/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.wizards.managedbean;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.ComboDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogFieldGroup;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.IDialogFieldApplyListener;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.IStringButtonAdapter;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.LayoutUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StatusInfo;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StringButtonDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StringDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.dialogs.ListEntriesWizard;
import org.eclipse.wtp.jsf.facesconfig.editor.dialogs.MapEntriesWizard;
import org.eclipse.wtp.jsf.facesconfig.editor.dialogs.ValueEditDialog;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.ManagedPropertyRecorder;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.StructuredModelUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.TypeSelectionDialogUtil;

public class AddEditManagedBeanPropertyGroup
extends DialogFieldGroup {
    private static final int DEFAULT_CONTROL_WIDTH = 200;
    private StringDialogField nameField;
    private StringButtonDialogField classField;
    private ComboDialogField valueTypeField;
    private StringButtonDialogField valueField;
    private static EditorResources resource = EditorResources.getInstance();
    private ManagedPropertyRecorder propertyRecorder;
    private IProject currentProject;
    private FormToolkit toolkit;
    private Composite parent;
    public static final String[] valueTypes = new String[]{"value", "null-value", "map-entries", "list-entries"};

    public AddEditManagedBeanPropertyGroup(ManagedPropertyRecorder propertyRecorder) {
        this.propertyRecorder = propertyRecorder;
    }

    private IProject getProject() {
        if (this.currentProject == null && this.propertyRecorder.getBean() != null && this.propertyRecorder.getBean().getNode() != null) {
            this.currentProject = StructuredModelUtil.getProjectFor(this.propertyRecorder.getBean().getNode());
        }
        return this.currentProject;
    }

    public void initialize() {
        this.nameField = new StringDialogField(0);
        this.nameField.setLabelText(resource.getString("ManagedBeanPropertyEditDialog.PropertyName"));
        this.nameField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                AddEditManagedBeanPropertyGroup.this.handleNameSelection(AddEditManagedBeanPropertyGroup.this.nameField.getText());
                AddEditManagedBeanPropertyGroup.this.getDefaultChangeListener().dialogFieldChanged(field);
            }
        });
        this.nameField.setDialogFieldChangeListener(this.getDefaultChangeListener());
        this.classField = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                TypeSelectionDialogUtil.handleFindType(((StringButtonDialogField)field).getTextControl(AddEditManagedBeanPropertyGroup.this.toolkit, AddEditManagedBeanPropertyGroup.this.parent), AddEditManagedBeanPropertyGroup.this.getProject());
            }
        });
        this.classField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                AddEditManagedBeanPropertyGroup.this.propertyRecorder.setPropertyClass(AddEditManagedBeanPropertyGroup.this.classField.getText());
            }
        });
        this.classField.setDialogFieldChangeListener(this.getDefaultChangeListener());
        this.classField.setLabelText(resource.getString("ManagedBeanPropertyEditDialog.PropertyClass"));
        this.valueTypeField = new ComboDialogField(2060);
        this.valueTypeField.setLabelText(resource.getString("ManagedBeanPropertyEditDialog.ValueType"));
        this.valueTypeField.setItems(valueTypes);
        this.valueTypeField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                AddEditManagedBeanPropertyGroup.this.propertyRecorder.setValueType(AddEditManagedBeanPropertyGroup.this.valueTypeField.getText());
                AddEditManagedBeanPropertyGroup.this.updateValueStatus();
            }
        });
        this.valueField = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                AddEditManagedBeanPropertyGroup.this.handleChangeValue(((StringButtonDialogField)field).getTextControl(AddEditManagedBeanPropertyGroup.this.toolkit, AddEditManagedBeanPropertyGroup.this.parent));
            }
        });
        this.valueField.setLabelText(resource.getString("ManagedBeanPropertyEditDialog.Value"));
        this.valueField.setButtonLabel(resource.getString("ManagedBeanPropertyEditDialog.Value.Change"));
        this.valueField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                AddEditManagedBeanPropertyGroup.this.propertyRecorder.setValue(AddEditManagedBeanPropertyGroup.this.valueField.getText());
            }
        });
    }

    protected void handleNameSelection(String text) {
        this.propertyRecorder.setPropertyName(text);
        int propertyCount = this.propertyRecorder.getClassProperties().size();
        if (propertyCount > 0) {
            int i = 0;
            while (i < propertyCount) {
                ManagedPropertyRecorder.ClassProperty property = (ManagedPropertyRecorder.ClassProperty)this.propertyRecorder.getClassProperties().get(i);
                if (property._propertyName.equals(text.trim())) {
                    this.classField.setText(property._propertyClass);
                    break;
                }
                ++i;
            }
        }
    }

    protected void handleChangeValue(Text textControl) {
        if (this.propertyRecorder.getValueType().equalsIgnoreCase("value")) {
            this.handleChangeLongStringValue(textControl);
        } else if (this.propertyRecorder.getValueType().equalsIgnoreCase("map-entries")) {
            this.handleChangeMapEntries(textControl);
        } else if (this.propertyRecorder.getValueType().equalsIgnoreCase("list-entries")) {
            this.handleChangeListEntries(textControl);
        }
    }

    private void handleChangeLongStringValue(Text textControl) {
        ValueEditDialog valueDialog = new ValueEditDialog(EditorPlugin.getActiveWorkbenchWindow().getShell(), textControl.getText());
        if (valueDialog.open() == 0) {
            textControl.setText((String)valueDialog.getResultData());
            this.propertyRecorder.setValue(this.valueField.getText());
        }
    }

    private void handleChangeMapEntries(Text textControl) {
        MapEntriesWizard wizard = new MapEntriesWizard(this.propertyRecorder.getMapEntries(), this.getProject());
        wizard.init(EditorPlugin.getActiveWorkbenchWindow().getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
        wizard.setForcePreviousAndNextButtons(false);
        WizardDialog wizardDialog = new WizardDialog(EditorPlugin.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        wizardDialog.create();
        if (wizardDialog.open() == 0) {
            this.valueField.setTextWithoutUpdate(this.propertyRecorder.getMapEntries().toString());
        }
    }

    private void handleChangeListEntries(Text textControl) {
        ListEntriesWizard wizard = new ListEntriesWizard(this.propertyRecorder.getListEntries(), this.getProject());
        wizard.init(EditorPlugin.getActiveWorkbenchWindow().getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
        wizard.setForcePreviousAndNextButtons(false);
        WizardDialog wizardDialog = new WizardDialog(EditorPlugin.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        wizardDialog.create();
        if (wizardDialog.open() == 0) {
            this.valueField.setTextWithoutUpdate(this.propertyRecorder.getListEntries().toString());
        }
    }

    public void refreshData() {
        if (this.propertyRecorder == null) {
            return;
        }
        this.nameField.setTextWithoutUpdate(this.propertyRecorder.getPropertyName());
        this.classField.setTextWithoutUpdate(this.propertyRecorder.getPropertyClass());
        this.valueTypeField.setTextWithoutUpdate(this.propertyRecorder.getValueType());
        if (this.propertyRecorder.getValueType().equalsIgnoreCase("value")) {
            this.valueField.setTextWithoutUpdate(this.propertyRecorder.getValue());
        } else if (this.propertyRecorder.getValueType().equalsIgnoreCase("map-entries")) {
            this.valueField.setTextWithoutUpdate(this.propertyRecorder.getMapEntries().toString());
        } else if (this.propertyRecorder.getValueType().equalsIgnoreCase("list-entries")) {
            this.valueField.setTextWithoutUpdate(this.propertyRecorder.getListEntries().toString());
        }
        this.updateValueStatus();
    }

    private void updateValueStatus() {
        if (this.valueField == null) {
            return;
        }
        if (this.valueTypeField.getText().equalsIgnoreCase("null-value")) {
            this.valueField.setEnabled(false);
        } else if (this.valueTypeField.getText().equalsIgnoreCase("map-entries") || this.valueTypeField.getText().equalsIgnoreCase("list-entries")) {
            this.valueField.getTextControl(this.toolkit, this.parent).setEditable(false);
            this.valueField.setEnabled(true);
        } else {
            this.valueField.getTextControl(this.toolkit, this.parent).setEditable(true);
            this.valueField.setEnabled(true);
        }
    }

    public void layoutDialogFields(FormToolkit toolkit, Composite parent) {
        this.toolkit = toolkit;
        this.parent = parent;
        GridData data = new GridData(1808);
        parent.setLayoutData((Object)data);
        int numberOfColumns = 5;
        GridLayout gl = new GridLayout(numberOfColumns, false);
        parent.setLayout((Layout)gl);
        this.nameField.doFillIntoGrid(toolkit, parent, numberOfColumns);
        LayoutUtil.setWidthHint((Control)this.nameField.getTextControl(toolkit, parent), (int)200);
        this.classField.doFillIntoGrid(toolkit, parent, numberOfColumns - 1);
        data = new GridData(4, 0x1000000, false, false);
        data.horizontalSpan = 2;
        this.classField.getChangeControl(toolkit, parent).setLayoutData((Object)data);
        LayoutUtil.setWidthHint((Control)this.classField.getTextControl(toolkit, parent), (int)200);
        this.valueTypeField.doFillIntoGrid(toolkit, parent, numberOfColumns);
        this.valueField.doFillIntoGrid(toolkit, parent, numberOfColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.classField.getTextControl(toolkit, parent));
    }

    public IStatus[] validateDialogFields() {
        StatusInfo nameStatus = new StatusInfo();
        StatusInfo classStatus = new StatusInfo();
        IStatus[] status = new IStatus[]{nameStatus, classStatus};
        if (this.nameField.getText().length() == 0) {
            nameStatus.setError(EditorResources.getInstance().getString("ManagedBeanPropertyGroup.error.EmptyName"));
        }
        if (this.classField.getText().length() == 0) {
            classStatus.setError(EditorResources.getInstance().getString("ManagedBeanPropertyGroup.error.EmptyClass"));
        }
        return status;
    }

    public void setProject(IProject project) {
        this.currentProject = project;
    }
}

