/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.NodeWrapUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class StructuredModelUtil {
    public static IFile getFileFor(IStructuredModel model) {
        if (model == null) {
            return null;
        }
        String path = model.getBaseLocation();
        if (path == null || path.length() == 0) {
            String id = model.getId();
            if (id == null) {
                return null;
            }
            path = id.toString();
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFile((IPath)new Path(path));
        return file;
    }

    public static IProject getProjectFor(IStructuredModel model) {
        IProject project = null;
        IFile file = StructuredModelUtil.getFileFor(model);
        if (file != null) {
            project = file.getProject();
        }
        return project;
    }

    public static IProject getProjectFor(IDOMNode node) {
        IFile file;
        IProject project = null;
        if (node != null && (file = StructuredModelUtil.getFileFor((IStructuredModel)node.getModel())) != null) {
            project = file.getProject();
        }
        return project;
    }

    public static Node getTextElement(Element ele) {
        Node textNode = null;
        Node node = ele.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 3 || node.getNodeType() == 4) {
                textNode = node;
            }
            node = node.getNextSibling();
        }
        return textNode;
    }

    public static String getTextElementValue(Element ele) {
        StringBuffer buffer = new StringBuffer();
        Node node = StructuredModelUtil.getTextElement(ele);
        if (node != null) {
            buffer.append(NodeWrapUtil.unEscapeEntities(node.getNodeValue()));
        }
        return buffer.toString();
    }

    public static void removeAllChildren(Element ele) {
        ((ElementImpl)ele).removeChildNodes();
    }

    public static void setTextElementValue(Element ele, String value) {
        if (value == null) {
            return;
        }
        Node textNode = ele.getFirstChild();
        if (!(textNode instanceof Text)) {
            Text subText = ele.getOwnerDocument().createTextNode(value);
            ele.appendChild(subText);
        } else {
            ((Text)textNode).setNodeValue(value);
        }
    }

    public static void propagateAddAdapter(IDOMNode node, INodeAdapter adapter, Object adapterType) {
        NodeList childNodes;
        if (node == null || adapter == null) {
            return;
        }
        if (node.getAdapterFor(adapterType) == null) {
            node.addAdapter(adapter);
        }
        if ((childNodes = node.getChildNodes()) != null && childNodes.getLength() > 0) {
            int i = 0;
            while (i < childNodes.getLength()) {
                Node childNode = childNodes.item(i);
                if (childNode instanceof Element) {
                    StructuredModelUtil.propagateAddAdapter((IDOMNode)childNode, adapter, adapterType);
                }
                ++i;
            }
        }
    }

    public static void propagateRemoveAdapter(IDOMNode node, INodeAdapter adapter) {
        if (node == null || adapter == null) {
            return;
        }
        node.removeAdapter(adapter);
        NodeList childNodes = node.getChildNodes();
        if (childNodes != null && childNodes.getLength() > 0) {
            int i = 0;
            while (i < childNodes.getLength()) {
                Node childNode = childNodes.item(i);
                if (childNode instanceof Element) {
                    StructuredModelUtil.propagateRemoveAdapter((IDOMNode)childNode, adapter);
                }
                ++i;
            }
        }
    }
}

