/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.utils;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.ManagedBean;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.ConfigurationManager;

public class ManagedBeanUtils {
    private static ConfigurationManager facesConfigManager;

    public static boolean isBeanDuplicate(IProject project, String beanName) {
        List[] beanlist = ManagedBeanUtils.getConfigurationManager(project).getManagedBeans();
        if (beanlist != null) {
            int x = 0;
            while (x < beanlist.length) {
                List beans = beanlist[x];
                Iterator i = beans.iterator();
                while (i.hasNext()) {
                    ManagedBean mbti;
                    String name;
                    Object o = i.next();
                    if (!(o instanceof ManagedBean) || !(name = (mbti = (ManagedBean)o).getManagedBeanName().trim()).equals(beanName)) continue;
                    return true;
                }
                ++x;
            }
        }
        return false;
    }

    public static ConfigurationManager getConfigurationManager(IProject project) {
        if (facesConfigManager == null) {
            facesConfigManager = new ConfigurationManager(project);
        }
        facesConfigManager.loadConfiguration(project);
        facesConfigManager.deriveManagedBeans();
        return facesConfigManager;
    }

    public static String getDefaultManagedBeanName(IProject project, String refName) {
        String defaultName = refName;
        int newRefNameIndex = 1;
        while (ManagedBeanUtils.isBeanDuplicate(project, defaultName)) {
            defaultName = String.valueOf(refName) + newRefNameIndex;
            ++newRefNameIndex;
        }
        return defaultName;
    }

    public static boolean isBeanDuplicate(ConfigurationManager configManager, String beanName) {
        List[] beanlist = configManager.getManagedBeans();
        if (beanlist != null) {
            int x = 0;
            while (x < beanlist.length) {
                List beans = beanlist[x];
                Iterator i = beans.iterator();
                while (i.hasNext()) {
                    ManagedBean mbti;
                    String name;
                    Object o = i.next();
                    if (!(o instanceof ManagedBean) || !(name = (mbti = (ManagedBean)o).getManagedBeanName().trim()).equals(beanName)) continue;
                    return true;
                }
                ++x;
            }
        }
        return false;
    }
}

