/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.sections.editgroups;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogFieldGroup;
import org.eclipse.wtp.jsf.facesconfig.editor.dialogs.IDialogFieldGroup;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.NodeWrapUtil;

public class PropertiesEditGroup
extends DialogFieldGroup
implements IDialogFieldGroup {
    private static EditorResources resource = EditorResources.getInstance();
    private Table propertiesTable;
    private static final int TABLE_DEFAULT_HEIGHT = 160;
    private Composite generalSection;
    private Button addPropertyButton;
    private Button removePropertyButton;
    private Button editPropertyButton;
    private IDOMNode componentNode;

    public void initialize() {
    }

    public void refreshData() {
        this.clearPropertiesTable();
        this.appendExisitingComponentProperties();
        this.updatePropertyButtons();
    }

    public void layoutDialogFields(FormToolkit toolkit, Composite parent) {
        this.createPropertyEntry(parent, toolkit);
    }

    public IStatus[] validateDialogFields() {
        return null;
    }

    public void createPropertyEntry(Composite container, FormToolkit toolkit) {
        this.generalSection = toolkit.createComposite(container);
        this.generalSection.setLayoutData((Object)new GridData(1808));
        toolkit.paintBordersFor(this.generalSection);
        GridLayout gl = new GridLayout();
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.numColumns = 2;
        this.generalSection.setLayout((Layout)gl);
        this.createTableSection(this.generalSection, toolkit);
        this.createButtonsSection(this.generalSection, toolkit);
    }

    private void createTableSection(Composite container, FormToolkit toolkit) {
        Composite propertyContainer = toolkit.createComposite(container);
        GridData gd = new GridData(1808);
        propertyContainer.setLayoutData((Object)gd);
        toolkit.paintBordersFor(propertyContainer);
        GridLayout gl = new GridLayout();
        propertyContainer.setLayout((Layout)gl);
        this.propertiesTable = new Table(propertyContainer, 66304);
        gd = new GridData(1808);
        gd.horizontalSpan = 1;
        gd.heightHint = 160;
        this.propertiesTable.setLayoutData((Object)gd);
        this.propertiesTable.setHeaderVisible(true);
        this.propertiesTable.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        this.propertiesTable.setLayout((Layout)layout);
        TableColumn propertyCol = new TableColumn(this.propertiesTable, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        propertyCol.setText(resource.getString("ComponentsPage.PropertiesSection.Table.NameColumn"));
        TableColumn classCol = new TableColumn(this.propertiesTable, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        classCol.setText(resource.getString("ComponentsPage.PropertiesSection.Table.ClassColumn"));
        TableColumn valueCol = new TableColumn(this.propertiesTable, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        valueCol.setText(resource.getString("ComponentsPage.PropertiesSection.Table.DefaultValueColumn"));
        this.propertiesTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesEditGroup.this.handlePropertySelection(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                PropertiesEditGroup.this.handlePropertySelection(e);
            }
        });
    }

    protected void handlePropertySelection(SelectionEvent e) {
        this.updatePropertyButtons();
    }

    private void updatePropertyButtons() {
        if (this.propertiesTable.getSelectionCount() > 0) {
            this.editPropertyButton.setEnabled(true);
            this.removePropertyButton.setEnabled(true);
        } else {
            this.editPropertyButton.setEnabled(false);
            this.removePropertyButton.setEnabled(false);
        }
    }

    private void createButtonsSection(Composite container, FormToolkit toolkit) {
        Composite operationContainer = toolkit.createComposite(container);
        GridData gd = new GridData(1042);
        operationContainer.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        operationContainer.setLayout((Layout)gl);
        this.addPropertyButton = toolkit.createButton(operationContainer, resource.getString("ComponentsPage.PropertiesSection.Button.Add.Name"), 8);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.addPropertyButton.setLayoutData((Object)gd);
        this.editPropertyButton = toolkit.createButton(operationContainer, resource.getString("ComponentsPage.PropertiesSection.Button.Edit.Name"), 8);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.editPropertyButton.setLayoutData((Object)gd);
        this.removePropertyButton = toolkit.createButton(operationContainer, resource.getString("ComponentsPage.PropertiesSection.Button.Remove.Name"), 8);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.removePropertyButton.setLayoutData((Object)gd);
    }

    public Button getEditButton() {
        return this.editPropertyButton;
    }

    public Button getAddButton() {
        return this.addPropertyButton;
    }

    public Button getRemoveButton() {
        return this.removePropertyButton;
    }

    public Table getPropertiesTable() {
        return this.propertiesTable;
    }

    private void appendExisitingComponentProperties() {
        NodeWrapUtil componentWrap = new NodeWrapUtil(this.componentNode);
        boolean hasProperty = false;
        List propertiesList = componentWrap.getChildNodes("property");
        if (propertiesList == null) {
            return;
        }
        int i = 0;
        while (i < propertiesList.size()) {
            IDOMNode propertyNode = (IDOMNode)propertiesList.get(i);
            this.addPropertyItem(propertyNode);
            hasProperty = true;
            ++i;
        }
        if (hasProperty) {
            this.propertiesTable.select(0);
        }
    }

    private void addPropertyItem(IDOMNode propertyNode) {
        NodeWrapUtil propertyWrap = new NodeWrapUtil(propertyNode);
        TableItem item = new TableItem(this.propertiesTable, 0);
        String propertyName = propertyWrap.getChildNodeValue("property-name");
        item.setText(0, propertyName);
        String propertyClass = propertyWrap.getChildNodeValue("property-class");
        item.setText(1, propertyClass);
        String defaultValue = propertyWrap.getChildNodeValue("default-value");
        item.setText(2, defaultValue);
        item.setData((Object)propertyNode);
    }

    private void clearPropertiesTable() {
        this.propertiesTable.removeAll();
    }

    public void setInput(Object newInput) {
        if (newInput != null && newInput instanceof IDOMNode) {
            this.componentNode = (IDOMNode)newInput;
            this.refreshData();
        }
    }

    public Object getInput() {
        return this.componentNode;
    }

    public void setPropertyName(IDOMNode node, String newName) {
        int itemIndex;
        if (node != null && (itemIndex = this.findItem(node)) >= 0) {
            this.propertiesTable.getItem(itemIndex).setText(0, newName.trim());
            this.propertiesTable.select(itemIndex);
        }
    }

    public void setPropertyClass(IDOMNode node, String newClass) {
        int itemIndex;
        if (node != null && (itemIndex = this.findItem(node)) >= 0) {
            this.propertiesTable.getItem(itemIndex).setText(1, newClass.trim());
            this.propertiesTable.select(itemIndex);
        }
    }

    public void setPropertyDefaultValue(IDOMNode node, String newDefaultValue) {
        int itemIndex;
        if (node != null && (itemIndex = this.findItem(node)) >= 0) {
            this.propertiesTable.getItem(itemIndex).setText(2, newDefaultValue.trim());
            this.propertiesTable.select(itemIndex);
        }
    }

    public void removeItem(IDOMNode node) {
        int itemIndex;
        if (node != null && (itemIndex = this.findItem(node)) >= 0) {
            this.propertiesTable.remove(itemIndex);
            this.propertiesTable.select(itemIndex - 1);
            this.updatePropertyButtons();
        }
    }

    public void addItem(IDOMNode node) {
        int index;
        if (node != null && (index = this.findItem(node)) < 0) {
            this.addPropertyItem(node);
            this.propertiesTable.select(this.propertiesTable.getItemCount() - 1);
        }
    }

    protected int findItem(IDOMNode node) {
        int itemIndex = -1;
        TableItem[] items = this.propertiesTable.getItems();
        int i = 0;
        while (i < this.propertiesTable.getItemCount()) {
            if (items[i].getData() == node) {
                itemIndex = i;
                break;
            }
            ++i;
        }
        return itemIndex;
    }
}

