/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.sections.editgroups;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogFieldGroup;
import org.eclipse.wtp.jsf.facesconfig.editor.dialogs.IDialogFieldGroup;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.NodeWrapUtil;

public class FacetsEditGroup
extends DialogFieldGroup
implements IDialogFieldGroup {
    private static EditorResources resource = EditorResources.getInstance();
    private Table table;
    private static final int TABLE_DEFAULT_HEIGHT = 160;
    private Composite generalSection;
    private Button addButton;
    private Button removeButton;
    private Button editButton;
    private IDOMNode componentNode;

    public void initialize() {
    }

    public void refreshData() {
        this.clearTable();
        this.appendExisitingFacets();
        this.updateButtons();
    }

    public void layoutDialogFields(FormToolkit toolkit, Composite parent) {
        this.createEntry(parent, toolkit);
    }

    public IStatus[] validateDialogFields() {
        return null;
    }

    public void createEntry(Composite container, FormToolkit toolkit) {
        this.generalSection = toolkit.createComposite(container);
        this.generalSection.setLayoutData((Object)new GridData(1808));
        toolkit.paintBordersFor(this.generalSection);
        GridLayout gl = new GridLayout();
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.numColumns = 2;
        this.generalSection.setLayout((Layout)gl);
        this.createTableSection(this.generalSection, toolkit);
        this.createButtonsSection(this.generalSection, toolkit);
    }

    private void createTableSection(Composite container, FormToolkit toolkit) {
        Composite propertyContainer = toolkit.createComposite(container);
        GridData gd = new GridData(1808);
        propertyContainer.setLayoutData((Object)gd);
        toolkit.paintBordersFor(propertyContainer);
        GridLayout gl = new GridLayout();
        propertyContainer.setLayout((Layout)gl);
        this.table = new Table(propertyContainer, 66304);
        gd = new GridData(1808);
        gd.horizontalSpan = 1;
        gd.heightHint = 160;
        this.table.setLayoutData((Object)gd);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        this.table.setLayout((Layout)layout);
        TableColumn facetNameCol = new TableColumn(this.table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        facetNameCol.setText(resource.getString("ComponentsPage.FacetsSection.Table.FacetNameColumn"));
        TableColumn displayNameCol = new TableColumn(this.table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        displayNameCol.setText(resource.getString("ComponentsPage.FacetsSection.Table.DisplayNameColumn"));
        TableColumn descriptionCol = new TableColumn(this.table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        descriptionCol.setText(resource.getString("ComponentsPage.FacetsSection.Table.DescriptionColumn"));
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FacetsEditGroup.this.handleSelection(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                FacetsEditGroup.this.handleSelection(e);
            }
        });
    }

    protected void handleSelection(SelectionEvent e) {
        this.updateButtons();
    }

    private void updateButtons() {
        if (this.table.getSelectionCount() > 0) {
            this.editButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    private void createButtonsSection(Composite container, FormToolkit toolkit) {
        Composite operationContainer = toolkit.createComposite(container);
        GridData gd = new GridData(1042);
        operationContainer.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        operationContainer.setLayout((Layout)gl);
        this.addButton = toolkit.createButton(operationContainer, resource.getString("ComponentsPage.FacetsSection.Button.Add.Name"), 8);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.addButton.setLayoutData((Object)gd);
        this.editButton = toolkit.createButton(operationContainer, resource.getString("ComponentsPage.FacetsSection.Button.Edit.Name"), 8);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.editButton.setLayoutData((Object)gd);
        this.removeButton = toolkit.createButton(operationContainer, resource.getString("ComponentsPage.FacetsSection.Button.Remove.Name"), 8);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.removeButton.setLayoutData((Object)gd);
    }

    public Button getEditButton() {
        return this.editButton;
    }

    public Button getAddButton() {
        return this.addButton;
    }

    public Button getRemoveButton() {
        return this.removeButton;
    }

    public Table getTable() {
        return this.table;
    }

    private void appendExisitingFacets() {
        NodeWrapUtil componentWrap = new NodeWrapUtil(this.componentNode);
        boolean hasFacet = false;
        List facesList = componentWrap.getChildNodes("facet");
        if (facesList == null) {
            return;
        }
        int i = 0;
        while (i < facesList.size()) {
            IDOMNode facetNode = (IDOMNode)facesList.get(i);
            this.addFacetItem(facetNode);
            hasFacet = true;
            ++i;
        }
        if (hasFacet) {
            this.table.select(0);
        }
    }

    private void addFacetItem(IDOMNode facetNode) {
        NodeWrapUtil facetWrap = new NodeWrapUtil(facetNode);
        TableItem item = new TableItem(this.table, 0);
        String facetName = facetWrap.getChildNodeValue("facet-name");
        String displayName = facetWrap.getChildNodeValue("display-name");
        String description = facetWrap.getChildNodeValue("description");
        item.setText(0, facetName);
        item.setText(1, displayName);
        item.setText(2, description);
        item.setData((Object)facetNode);
    }

    private void clearTable() {
        this.table.removeAll();
    }

    public void setInput(Object newInput) {
        if (newInput != null && newInput instanceof IDOMNode) {
            this.componentNode = (IDOMNode)newInput;
            this.refreshData();
        }
    }

    public Object getInput() {
        return this.componentNode;
    }

    public void setFacetDisplayName(IDOMNode node, String newName) {
        int itemIndex;
        if (node != null && (itemIndex = this.findItem(node)) >= 0) {
            this.table.getItem(itemIndex).setText(1, newName.trim());
            this.table.select(itemIndex);
        }
    }

    public void setFacetName(IDOMNode node, String newClass) {
        int itemIndex;
        if (node != null && (itemIndex = this.findItem(node)) >= 0) {
            this.table.getItem(itemIndex).setText(0, newClass.trim());
            this.table.select(itemIndex);
        }
    }

    public void setFacetDescription(IDOMNode node, String newDescription) {
        int itemIndex;
        if (node != null && (itemIndex = this.findItem(node)) >= 0) {
            this.table.getItem(itemIndex).setText(2, newDescription.trim());
            this.table.select(itemIndex);
        }
    }

    public void removeItem(IDOMNode node) {
        int itemIndex;
        if (node != null && (itemIndex = this.findItem(node)) >= 0) {
            this.table.remove(itemIndex);
            this.table.select(itemIndex - 1);
            this.updateButtons();
        }
    }

    public void addItem(IDOMNode node) {
        int index;
        if (node != null && (index = this.findItem(node)) < 0) {
            this.addFacetItem(node);
            this.table.select(this.table.getItemCount() - 1);
        }
    }

    protected int findItem(IDOMNode node) {
        int itemIndex = -1;
        TableItem[] items = this.table.getItems();
        int i = 0;
        while (i < this.table.getItemCount()) {
            if (items[i].getData() == node) {
                itemIndex = i;
                break;
            }
            ++i;
        }
        return itemIndex;
    }
}

