/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.sections;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.common.actions.OpenPageAction;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.FacesConfig;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.ManagedBean;
import org.eclipse.wtp.jsf.facesconfig.editor.sections.AbstractOverviewSection;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.FacesConfigUtil;

public class OverviewManagedBeanSection
extends AbstractOverviewSection {
    private static EditorResources resource = EditorResources.getInstance();
    private static final int NAME = 0;
    private static final int SCOPE = 1;
    private ArrayList mbeans = null;
    private TableViewer tableViewer;

    public OverviewManagedBeanSection(IManagedForm managedForm, FormToolkit toolkit, FormEditor editor) {
        super(editor, managedForm, toolkit, 194, resource.getString("OverviewPage.ManagedBeanSection.Help.HelpContextID"), resource.getString("OverviewPage.ManagedBeanSection.Help.HelpToolTip"));
        this.setText(resource.getString("OverviewPage.ManagedBeanSection.name"));
        this.setDescription(resource.getString("OverviewPage.ManagedBeanSection.description"));
    }

    public Composite createClient(Composite container, FormToolkit factory) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 6;
        container.setLayout((Layout)layout);
        factory.paintBordersFor(container);
        Table table = new Table(container, 66304);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 1;
        gd.heightHint = 100;
        table.setLayoutData((Object)gd);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableLayout tablelayout = new TableLayout();
        table.setLayout((Layout)tablelayout);
        TableColumn namecol = new TableColumn(table, 16384);
        namecol.setText(resource.getString("OverviewPage.ManagedBeanSection.table.namecol"));
        tablelayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        namecol.setResizable(true);
        TableColumn scopecol = new TableColumn(table, 16384);
        scopecol.setText(resource.getString("OverviewPage.ManagedBeanSection.table.scopecol"));
        tablelayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        scopecol.setResizable(true);
        table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                OpenPageAction action = new OpenPageAction();
                action.setPageName("org.eclipse.wtp.jsf.facesconfig.editor.pages.ManagedBeanPage");
                action.run();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.setSorter(new ViewerSorter());
        EditorPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)container, resource.getString("OverviewPage.ManagedBeanSection.Help.HelpContextID"));
        return container;
    }

    public void refreshAll() {
        if (this.getInput() == null || !(this.getInput() instanceof IDOMModel)) {
            return;
        }
        List beanList = null;
        ManagedBean mbean = null;
        FacesConfig fconfig = FacesConfigUtil.getFacesConfig((IStructuredModel)((IDOMModel)this.getInput()));
        if (fconfig != null) {
            beanList = fconfig.getManagedBeanList();
            int count = beanList.size();
            this.mbeans = new ArrayList(count);
            if (beanList != null) {
                int i = 0;
                while (i < count) {
                    mbean = (ManagedBean)beanList.get(i);
                    this.mbeans.add(new MBeanElement(mbean.getManagedBeanName().trim(), mbean.getManagedBeanScope().trim()));
                    ++i;
                }
            }
            this.tableViewer.setInput((Object)this.mbeans);
        }
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return OverviewManagedBeanSection.this.mbeans.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            MBeanElement elem = (MBeanElement)element;
            switch (columnIndex) {
                case 0: {
                    return elem.getName();
                }
                case 1: {
                    return elem.getScope();
                }
            }
            return "";
        }
    }

    class MBeanElement {
        String _name;
        String _scope;

        public MBeanElement(String name, String scope) {
            this._name = name;
            this._scope = scope;
        }

        void setName(String value) {
            this._name = value;
        }

        void setScope(String value) {
            this._scope = value;
        }

        public String getName() {
            return this._name;
        }

        public String getScope() {
            return this._scope;
        }

        public String toString() {
            return String.valueOf(this._name) + "\\t" + this._scope;
        }
    }
}

