/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.pageflow.layout;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.layout.DirectedGraph;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.layout.Edge;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.layout.GraphVisitor;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.layout.Node;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.layout.NodeList;

class BreakCycles
extends GraphVisitor {
    NodeList graphNodes = new NodeList();

    BreakCycles() {
    }

    private boolean allNodesFlagged() {
        int i = 0;
        while (i < this.graphNodes.size()) {
            if (!this.graphNodes.getNode((int)i).flag) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void breakCycles(DirectedGraph g) {
        this.initializeDegrees(g);
        this.greedyCycleRemove(g);
        this.invertEdges(g);
    }

    private boolean containsCycles(DirectedGraph g) {
        ArrayList noLefts = new ArrayList();
        int i = 0;
        while (i < this.graphNodes.size()) {
            Node node = this.graphNodes.getNode(i);
            if (this.getIncomingCount(node) == 0) {
                this.sortedInsert(noLefts, node);
            }
            ++i;
        }
        while (noLefts.size() > 0) {
            Node node = (Node)noLefts.remove(noLefts.size() - 1);
            node.flag = true;
            int i2 = 0;
            while (i2 < node.outgoing.size()) {
                Node right = node.outgoing.getEdge((int)i2).target;
                this.setIncomingCount(right, this.getIncomingCount(right) - 1);
                if (this.getIncomingCount(right) == 0) {
                    this.sortedInsert(noLefts, right);
                }
                ++i2;
            }
        }
        return !this.allNodesFlagged();
    }

    private Node findNodeWithMaxDegree() {
        int max = Integer.MIN_VALUE;
        Node maxNode = null;
        int i = 0;
        while (i < this.graphNodes.size()) {
            Node node = this.graphNodes.getNode(i);
            if (this.getDegree(node) >= max && !node.flag) {
                max = this.getDegree(node);
                maxNode = node;
            }
            ++i;
        }
        return maxNode;
    }

    private int getDegree(Node n) {
        return n.workingInts[3];
    }

    private int getIncomingCount(Node n) {
        return n.workingInts[0];
    }

    private int getInDegree(Node n) {
        return n.workingInts[1];
    }

    private int getOrderIndex(Node n) {
        return n.workingInts[0];
    }

    private int getOutDegree(Node n) {
        return n.workingInts[2];
    }

    private void greedyCycleRemove(DirectedGraph g) {
        int i;
        NodeList sL = new NodeList();
        NodeList sR = new NodeList();
        while (true) {
            boolean hasSource;
            boolean hasSink = false;
            i = 0;
            while (i < this.graphNodes.size()) {
                Node node = this.graphNodes.getNode(i);
                if (this.getOutDegree(node) == 0 && !node.flag) {
                    hasSink = true;
                    node.flag = true;
                    this.updateIncoming(node);
                    sR.add(node);
                    break;
                }
                ++i;
            }
            if (hasSink) continue;
            block2: do {
                hasSource = false;
                int i2 = 0;
                while (i2 < this.graphNodes.size()) {
                    Node node = this.graphNodes.getNode(i2);
                    if (this.getInDegree(node) == 0 && !node.flag) {
                        hasSource = true;
                        node.flag = true;
                        this.updateOutgoing(node);
                        sL.add(node);
                        continue block2;
                    }
                    ++i2;
                }
            } while (hasSource);
            Node max = this.findNodeWithMaxDegree();
            if (max != null) {
                sL.add(max);
                max.flag = true;
                this.updateIncoming(max);
                this.updateOutgoing(max);
            }
            if (this.allNodesFlagged()) break;
        }
        int orderIndex = 0;
        i = 0;
        while (i < sL.size()) {
            this.setOrderIndex(sL.getNode(i), orderIndex++);
            ++i;
        }
        i = sR.size() - 1;
        while (i >= 0) {
            this.setOrderIndex(sR.getNode(i), orderIndex++);
            --i;
        }
    }

    private void initializeDegrees(DirectedGraph g) {
        this.graphNodes.resetFlags();
        int i = 0;
        while (i < g.nodes.size()) {
            Node n = this.graphNodes.getNode(i);
            this.setInDegree(n, n.incoming.size());
            this.setOutDegree(n, n.outgoing.size());
            this.setDegree(n, n.outgoing.size() - n.incoming.size());
            ++i;
        }
    }

    private void invertEdges(DirectedGraph g) {
        int i = 0;
        while (i < g.edges.size()) {
            Edge e = g.edges.getEdge(i);
            if (this.getOrderIndex(e.source) > this.getOrderIndex(e.target)) {
                e.invert();
                e.isFeedback = true;
            }
            ++i;
        }
    }

    private void setDegree(Node n, int deg) {
        n.workingInts[3] = deg;
    }

    private void setIncomingCount(Node n, int count) {
        n.workingInts[0] = count;
    }

    private void setInDegree(Node n, int deg) {
        n.workingInts[1] = deg;
    }

    private void setOutDegree(Node n, int deg) {
        n.workingInts[2] = deg;
    }

    private void setOrderIndex(Node n, int index) {
        n.workingInts[0] = index;
    }

    private void sortedInsert(List list, Node node) {
        int insert = 0;
        while (insert < list.size() && ((Node)list.get((int)insert)).sortValue > node.sortValue) {
            ++insert;
        }
        list.add(insert, node);
    }

    private void updateIncoming(Node n) {
        int i = 0;
        while (i < n.incoming.size()) {
            Node in = n.incoming.getEdge((int)i).source;
            if (!in.flag) {
                this.setOutDegree(in, this.getOutDegree(in) - 1);
                this.setDegree(in, this.getOutDegree(in) - this.getInDegree(in));
            }
            ++i;
        }
    }

    private void updateOutgoing(Node n) {
        int i = 0;
        while (i < n.outgoing.size()) {
            Node out = n.outgoing.getEdge((int)i).target;
            if (!out.flag) {
                this.setInDegree(out, this.getInDegree(out) - 1);
                this.setDegree(out, this.getOutDegree(out) - this.getInDegree(out));
            }
            ++i;
        }
    }

    public void visit(DirectedGraph g) {
        this.graphNodes.resetFlags();
        int i = 0;
        while (i < g.nodes.size()) {
            Node n = g.nodes.getNode(i);
            this.setIncomingCount(n, n.incoming.size());
            this.graphNodes.add(n);
            ++i;
        }
        if (this.containsCycles(g)) {
            this.breakCycles(g);
        }
    }
}

