/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.model.xml;

import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.Renderer;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.FacesConfigOrderHelper;

public class RendererRecorder {
    private Renderer renderKitRenderer;
    private String displayName;
    private String componentFamily;
    private String rendererType;
    private String rendererClass;
    private IDOMModel domModel;

    public RendererRecorder(IDOMModel domModel) {
        this.renderKitRenderer = null;
        this.displayName = "";
        this.componentFamily = "";
        this.rendererType = "";
        this.rendererClass = "";
        this.domModel = domModel;
    }

    public RendererRecorder(IDOMModel domModel, Renderer renderKitRenderer) {
        this.renderKitRenderer = renderKitRenderer;
        this.displayName = this.renderKitRenderer.getDisplayName();
        this.componentFamily = this.renderKitRenderer.getComponentFamily();
        this.rendererType = this.renderKitRenderer.getRendererType();
        this.rendererClass = this.renderKitRenderer.getRendererClass();
        this.domModel = domModel;
    }

    public IDOMModel getDOMModel() {
        return this.domModel;
    }

    public void setDOMModel(IDOMModel domModel) {
        this.domModel = domModel;
    }

    public void update() {
        if (this.renderKitRenderer == null) {
            return;
        }
        if (this.renderKitRenderer.getElement().getChildNode("display-name") != null) {
            this.renderKitRenderer.getElement().setChildNodeValue("display-name", this.getDisplayName());
        } else if (this.getDisplayName().length() > 0) {
            this.renderKitRenderer.getElement().createChildNode("display-name", false, this.getDisplayName(), FacesConfigOrderHelper.getInstance());
        }
        if (this.renderKitRenderer.getElement().getChildNode("component-family") != null) {
            this.renderKitRenderer.getElement().setChildNodeValueKeepEmpty("component-family", this.getComponentFamily());
        } else {
            this.renderKitRenderer.getElement().createChildNode("component-family", false, this.getComponentFamily(), FacesConfigOrderHelper.getInstance());
        }
        if (this.renderKitRenderer.getElement().getChildNode("renderer-type") != null) {
            this.renderKitRenderer.getElement().setChildNodeValueKeepEmpty("renderer-type", this.getRendererType());
        } else {
            this.renderKitRenderer.getElement().createChildNode("renderer-type", false, this.getRendererType(), FacesConfigOrderHelper.getInstance());
        }
        if (this.renderKitRenderer.getElement().getChildNode("renderer-class") != null) {
            this.renderKitRenderer.getElement().setChildNodeValueKeepEmpty("renderer-class", this.getRendererClass());
        } else {
            this.renderKitRenderer.getElement().createChildNode("renderer-class", false, this.getRendererClass(), FacesConfigOrderHelper.getInstance());
        }
    }

    public String getComponentFamily() {
        return this.componentFamily;
    }

    public void setComponentFamily(String family) {
        this.componentFamily = family;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    public String getRendererClass() {
        return this.rendererClass;
    }

    public void setRendererClass(String class1) {
        this.rendererClass = class1;
    }

    public String getRendererType() {
        return this.rendererType;
    }

    public void setRendererType(String type) {
        this.rendererType = type;
    }

    public Renderer getRenderer() {
        return this.renderKitRenderer;
    }

    public void setRenderer(Renderer kitRenderer) {
        this.renderKitRenderer = kitRenderer;
    }
}

