/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.dialogs;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.IDialogFieldChangeListener;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StatusUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.dialogs.EditFacetGroup;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.FacetRecorder;

public class FacetEditWizardPage
extends WizardPage {
    private static EditorResources resource = EditorResources.getInstance();
    private FacetRecorder facetRecorder;
    private EditFacetGroup generalGroup;
    private IProject project;
    private IDialogFieldChangeListener defaultChangeListener = new IDialogFieldChangeListener(){

        public void dialogFieldChanged(DialogField field) {
            FacetEditWizardPage.this.validate();
        }
    };

    public FacetEditWizardPage(String pageName, FacetRecorder facetRecorder) {
        super(pageName);
        this.setTitle(resource.getString("ComponentsPage.FacetsSection.Wizard.Page.Title"));
        this.setDescription(resource.getString("ComponentsPage.FacetsSection.Wizard.Page.Description"));
        this.facetRecorder = facetRecorder;
    }

    public FacetEditWizardPage(String pageName, FacetRecorder facetRecorder, IProject project) {
        this(pageName, facetRecorder);
        this.project = project;
    }

    public FacetEditWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 4);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        this.setControl((Control)container);
        TabFolder tabFolder = new TabFolder(container, 4);
        tabFolder.setLayoutData((Object)gd);
        TabItem generalTabItem = new TabItem(tabFolder, 0);
        generalTabItem.setText("General");
        Control control = this.createGeneralTabControl((Composite)generalTabItem.getParent());
        generalTabItem.setControl(control);
        this.setPageComplete(false);
    }

    private Control createGeneralTabControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        composite.setFont(parent.getFont());
        this.generalGroup = new EditFacetGroup(this.facetRecorder);
        this.generalGroup.setDefaultChangeListener(this.defaultChangeListener);
        this.generalGroup.initialize();
        this.generalGroup.layoutDialogFields(null, composite);
        if (this.project != null) {
            this.generalGroup.setProject(this.project);
        }
        return composite;
    }

    public void validate() {
        IStatus[] statuses = this.generalGroup.validateDialogFields();
        IStatus status = StatusUtil.getMostSevere((IStatus[])statuses);
        StatusUtil.applyToStatusLine((DialogPage)this, (IStatus)status);
        this.setPageComplete(status == null || status.getSeverity() != 4);
    }
}

