/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.dialogs;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogFieldGroup;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.IDialogFieldApplyListener;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.LayoutUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StatusInfo;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StringDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.Facet;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.FacetRecorder;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.StructuredModelUtil;

public class EditFacetGroup
extends DialogFieldGroup {
    private FacetRecorder facetRecorder;
    private StringDialogField facetNameField;
    private StringDialogField displayNameField;
    private StringDialogField descriptionField;
    private IProject currentProject;
    private static EditorResources resource = EditorResources.getInstance();

    public EditFacetGroup(FacetRecorder facetRecorder) {
        this.facetRecorder = facetRecorder;
    }

    public void initialize() {
        this.facetNameField = new StringDialogField();
        this.facetNameField.setLabelText(resource.getString("ComponentsPage.FacetsSection.Wizard.Page.General.FacetName"));
        this.facetNameField.setText(this.facetRecorder.getFacetName());
        this.facetNameField.setDialogFieldChangeListener(this.getDefaultChangeListener());
        this.facetNameField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                EditFacetGroup.this.facetRecorder.setFacetName(EditFacetGroup.this.facetNameField.getText());
            }
        });
        this.displayNameField = new StringDialogField();
        this.displayNameField.setLabelText(resource.getString("ComponentsPage.FacetsSection.Wizard.Page.General.DisplayName"));
        this.displayNameField.setText(this.facetRecorder.getDisplayName());
        this.displayNameField.setDialogFieldChangeListener(this.getDefaultChangeListener());
        this.displayNameField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                EditFacetGroup.this.facetRecorder.setDisplayName(EditFacetGroup.this.displayNameField.getText());
            }
        });
        this.descriptionField = new StringDialogField();
        this.descriptionField.setLabelText(resource.getString("ComponentsPage.FacetsSection.Wizard.Page.General.Description"));
        this.descriptionField.setText(this.facetRecorder.getDescription());
        this.descriptionField.setDialogFieldChangeListener(this.getDefaultChangeListener());
        this.descriptionField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                EditFacetGroup.this.facetRecorder.setDescription(EditFacetGroup.this.descriptionField.getText());
            }
        });
    }

    protected IProject getProject() {
        IDOMNode node;
        Facet facet;
        if (this.currentProject == null && (facet = this.facetRecorder.getFacet()) != null && (node = facet.getNode()) != null) {
            this.currentProject = StructuredModelUtil.getProjectFor((IStructuredModel)node.getModel());
        }
        return this.currentProject;
    }

    public void setProject(IProject project) {
        this.currentProject = project;
    }

    public void refreshData() {
    }

    public void layoutDialogFields(FormToolkit toolkit, Composite parent) {
        GridData data = new GridData(1808);
        parent.setLayoutData((Object)data);
        int numberOfColumns = 3;
        GridLayout gl = new GridLayout(numberOfColumns, false);
        parent.setLayout((Layout)gl);
        this.facetNameField.doFillIntoGrid(toolkit, parent, numberOfColumns);
        this.displayNameField.doFillIntoGrid(toolkit, parent, numberOfColumns);
        this.descriptionField.doFillIntoGrid(toolkit, parent, numberOfColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.facetNameField.getTextControl(toolkit, parent));
    }

    public IStatus[] validateDialogFields() {
        StatusInfo nameStatus = new StatusInfo();
        IStatus[] status = new IStatus[]{nameStatus};
        if (this.facetNameField.getText().length() == 0) {
            nameStatus.setError(resource.getString("ComponentsPage.FacetsSection.Wizard.Page.EditFacetGroup.Error.NameEmpty"));
        }
        return status;
    }
}

