/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.commands;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.commands.Command;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.Pageflow;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.PageflowNode;

public class OrphanChildCommand
extends Command {
    private Point oldLocation;
    private Pageflow pageflow;
    private PageflowNode child;
    private int index;

    public OrphanChildCommand() {
        super(EditorResources.getInstance().getString("Pageflow.Commands.OrphanChildCommand.Label"));
    }

    public void execute() {
        EList children = this.pageflow.getNodes();
        this.index = children.indexOf(this.child);
        this.oldLocation = new Point(this.child.getX(), this.child.getY());
        this.pageflow.getNodes().remove((Object)this.child);
    }

    public void redo() {
        this.pageflow.getNodes().remove((Object)this.child);
    }

    public void undo() {
        this.child.setX(this.oldLocation.x);
        this.child.setY(this.oldLocation.y);
        this.pageflow.getNodes().add(this.index, (Object)this.child);
    }

    public void setChild(PageflowNode child) {
        this.child = child;
    }

    public void setParent(Pageflow parent) {
        this.pageflow = parent;
    }
}

