/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor;

import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.jface.util.ListenerList;

public class DelegatingZoomManager
extends ZoomManager
implements ZoomListener {
    private static final String DEFAULT_ZOOM_LEVEL_STRING = "100%";
    private static final double DEFAULT_ZOOM_LEVEL = 1.0;
    private static final int ZOOM_LISTENERLIST_INIT_SIZE = 3;
    private ZoomManager currentZoomManager = null;
    private ListenerList zoomListeners = new ListenerList(3);

    public DelegatingZoomManager() {
        super(null, null);
    }

    public void zoomChanged(double zoom) {
        Object[] listeners = this.zoomListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ZoomListener)listeners[i]).zoomChanged(zoom);
            ++i;
        }
    }

    public void addZoomListener(ZoomListener listener) {
        this.zoomListeners.add((Object)listener);
    }

    public void removeZoomListener(ZoomListener listener) {
        this.zoomListeners.remove((Object)listener);
    }

    public void setCurrentZoomManager(ZoomManager zoomManager) {
        if (this.currentZoomManager != null) {
            this.currentZoomManager.removeZoomListener((ZoomListener)this);
        }
        this.currentZoomManager = zoomManager;
        if (this.currentZoomManager != null) {
            this.currentZoomManager.addZoomListener((ZoomListener)this);
            this.zoomChanged(this.currentZoomManager.getZoom());
        }
    }

    public boolean canZoomIn() {
        if (this.currentZoomManager == null) {
            return false;
        }
        return this.currentZoomManager.canZoomIn();
    }

    public boolean canZoomOut() {
        if (this.currentZoomManager == null) {
            return false;
        }
        return this.currentZoomManager.canZoomOut();
    }

    public double getMaxZoom() {
        if (this.currentZoomManager == null) {
            return 1.0;
        }
        return this.currentZoomManager.getMaxZoom();
    }

    public double getMinZoom() {
        if (this.currentZoomManager == null) {
            return 1.0;
        }
        return this.currentZoomManager.getMinZoom();
    }

    public double getNextZoomLevel() {
        if (this.currentZoomManager == null) {
            return 1.0;
        }
        return this.currentZoomManager.getNextZoomLevel();
    }

    public double getPreviousZoomLevel() {
        if (this.currentZoomManager == null) {
            return 1.0;
        }
        return this.currentZoomManager.getPreviousZoomLevel();
    }

    public ScalableFigure getScalableFigure() {
        if (this.currentZoomManager == null) {
            return null;
        }
        return this.currentZoomManager.getScalableFigure();
    }

    public double getUIMultiplier() {
        if (this.currentZoomManager == null) {
            return 1.0;
        }
        return this.currentZoomManager.getUIMultiplier();
    }

    public Viewport getViewport() {
        if (this.currentZoomManager == null) {
            return null;
        }
        return this.currentZoomManager.getViewport();
    }

    public double getZoom() {
        if (this.currentZoomManager == null) {
            return 1.0;
        }
        return this.currentZoomManager.getZoom();
    }

    public String getZoomAsText() {
        if (this.currentZoomManager == null) {
            return DEFAULT_ZOOM_LEVEL_STRING;
        }
        return this.currentZoomManager.getZoomAsText();
    }

    public double[] getZoomLevels() {
        if (this.currentZoomManager == null) {
            return new double[]{1.0};
        }
        return this.currentZoomManager.getZoomLevels();
    }

    public String[] getZoomLevelsAsText() {
        if (this.currentZoomManager == null) {
            return new String[]{DEFAULT_ZOOM_LEVEL_STRING};
        }
        return this.currentZoomManager.getZoomLevelsAsText();
    }

    public void setUIMultiplier(double multiplier) {
        if (this.currentZoomManager == null) {
            return;
        }
        this.currentZoomManager.setUIMultiplier(multiplier);
    }

    public void setViewLocation(Point p) {
        if (this.currentZoomManager == null) {
            return;
        }
        this.currentZoomManager.setViewLocation(p);
    }

    public void setZoom(double zoom) {
        if (this.currentZoomManager == null) {
            return;
        }
        this.currentZoomManager.setZoom(zoom);
    }

    public void setZoomAnimationStyle(int style) {
        if (this.currentZoomManager == null) {
            return;
        }
        this.currentZoomManager.setZoomAnimationStyle(style);
    }

    public void setZoomAsText(String zoomString) {
        if (this.currentZoomManager == null) {
            return;
        }
        this.currentZoomManager.setZoomAsText(zoomString);
    }

    public void setZoomLevels(double[] zoomLevels) {
        if (this.currentZoomManager == null) {
            return;
        }
        this.currentZoomManager.setZoomLevels(zoomLevels);
    }

    public void zoomIn() {
        if (this.currentZoomManager == null) {
            return;
        }
        this.currentZoomManager.zoomIn();
    }

    public void zoomOut() {
        if (this.currentZoomManager == null) {
            return;
        }
        this.currentZoomManager.zoomOut();
    }

    public void zoomTo(Rectangle rect) {
        if (this.currentZoomManager == null) {
            return;
        }
        this.currentZoomManager.zoomTo(rect);
    }
}

