/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.utility.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.dali.internal.utility.JDBCType;

public class JDBCTypeTests
extends TestCase {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static void main(String[] args) {
        String[] stringArray = new String[2];
        stringArray[0] = "-c";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.JDBCTypeTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        TestRunner.main((String[])stringArray);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.JDBCTypeTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public JDBCTypeTests(String name) {
        super(name);
    }

    public void testTypesSize() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.sql.Types");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JDBCTypeTests.assertEquals((int)clazz.getDeclaredFields().length, (int)JDBCType.types().length);
    }

    public void testName() {
        JDBCType jdbcType = JDBCType.type((int)12);
        JDBCTypeTests.assertEquals((String)"VARCHAR", (String)jdbcType.getName());
        jdbcType = JDBCType.type((int)4);
        JDBCTypeTests.assertEquals((String)"INTEGER", (String)jdbcType.getName());
    }

    public void testCode() {
        JDBCType jdbcType = JDBCType.type((int)12);
        JDBCTypeTests.assertEquals((int)12, (int)jdbcType.getCode());
        jdbcType = JDBCType.type((int)4);
        JDBCTypeTests.assertEquals((int)4, (int)jdbcType.getCode());
    }

    public void testInvalidTypeCode() throws Exception {
        boolean exCaught = false;
        try {
            JDBCType jdbcType = JDBCType.type((int)55);
            JDBCTypeTests.fail((String)("invalid JDBCType: " + jdbcType));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        JDBCTypeTests.assertTrue((boolean)exCaught);
    }

    public void testInvalidTypeName() throws Exception {
        boolean exCaught = false;
        try {
            JDBCType jdbcType = JDBCType.type((String)"VARCHAR2");
            JDBCTypeTests.fail((String)("invalid JDBCType: " + jdbcType));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        JDBCTypeTests.assertTrue((boolean)exCaught);
    }
}

