/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.tests.model;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dali.core.DaliPlugin;
import org.eclipse.dali.core.tests.projects.TestDaliProject;
import org.eclipse.dali.orm.PersistenceFile;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;

public class PersistenceFileReferenceTests
extends TestCase {
    TestDaliProject testProject;
    PersistenceFile testPFile;
    PersistentType testPType;
    PersistentAttribute testPAttribute;
    PersistenceFile testRefPFile;
    PersistentType testRefPType;
    PersistentAttribute testRefPAttribute;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.core.tests.model.PersistenceFileReferenceTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public PersistenceFileReferenceTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.testProject = new TestDaliProject("TestProject", false);
        this.testProject.setPersistenceNature();
        IPackageFragment testPackage = this.testProject.createPackage("test");
        IType testClass = this.testProject.createType(testPackage, "TestClass.java", this.testClassText());
        IType testRefClass = this.testProject.createType(testPackage, "TestRefClass.java", this.testRefClassText());
        this.waitForJobs();
        this.testPFile = DaliPlugin.getPersistenceFile((IFile)((IFile)testClass.getResource()));
        this.testPType = (PersistentType)this.testPFile.getPersistentTypes().get(0);
        this.testPAttribute = (PersistentAttribute)this.testPType.getPersistentAttributes().get(0);
        this.testRefPFile = DaliPlugin.getPersistenceFile((IFile)((IFile)testRefClass.getResource()));
        this.testRefPType = (PersistentType)this.testRefPFile.getPersistentTypes().get(0);
        this.testRefPAttribute = (PersistentAttribute)this.testRefPType.getPersistentAttributes().get(0);
    }

    private String testClassText() {
        StringBuffer sb = new StringBuffer();
        sb.append("package test\n");
        sb.append("@Entity");
        sb.append("public class TestClass {\n");
        sb.append("    private String testField;\n");
        sb.append("    public String getTestField() { return null; }\n");
        sb.append("    public void setTestField(String testField) {}\n");
        sb.append("}");
        return sb.toString();
    }

    private String testRefClassText() {
        StringBuffer sb = new StringBuffer();
        sb.append("package test\n");
        sb.append("@Entity");
        sb.append("public class TestRefClass {\n");
        sb.append("    private String testField;\n");
        sb.append("    public String getTestField() { return null; }\n");
        sb.append("    public void setTestField(String testField) {}\n");
        sb.append("}");
        return sb.toString();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.waitForJobs();
        this.testProject.dispose();
        this.testProject = null;
        this.testPFile = null;
        this.testPType = null;
        this.testRefPFile = null;
        this.testRefPType = null;
    }

    public void waitForJobs() {
        while (Platform.getJobManager().currentJob() != null) {
        }
    }

    public void testPersistentTypeResolution() {
        PersistenceFileReferenceTests.assertNotNull((String)"The prebuilt \"test.TestClass\" is null", (Object)this.testPType);
        PersistenceFileReferenceTests.assertNotNull((String)"The prebuilt \"test.TestRefClass\" is null", (Object)this.testRefPType);
        PersistenceFileReferenceTests.assertNull((String)"Did not resolve nonsense type name to null", (Object)this.testPFile.resolvePersistentType("foobar"));
        PersistenceFileReferenceTests.assertEquals((String)"Did not resolve \"test.TestRefClass\" correctly", (Object)this.testRefPType, (Object)this.testPFile.resolvePersistentType("test.TestRefClass"));
        PersistenceFileReferenceTests.assertEquals((String)"Did not resolve \"test.TestClass\" correctly", (Object)this.testPType, (Object)this.testPFile.resolvePersistentType("test.TestClass"));
    }

    public void testPersistentAttributeResolution() {
        PersistenceFileReferenceTests.assertNotNull((String)"The prebuilt \"test.TestClass.testField\" is null", (Object)this.testPAttribute);
        PersistenceFileReferenceTests.assertNotNull((String)"The prebuilt \"test.TestRefClass.testField\" is null", (Object)this.testRefPAttribute);
        PersistenceFileReferenceTests.assertNull((String)"Did not resolve nonsense type name to null", (Object)this.testPFile.resolvePersistentAttribute("foobar", "testField"));
        PersistenceFileReferenceTests.assertNull((String)"Did not resolve nonsense attribute name to null", (Object)this.testPFile.resolvePersistentAttribute("test.TestRefClass", "foobar"));
        PersistenceFileReferenceTests.assertEquals((String)"Did not resolve \"test.TestRefClass.testField\" correctly", (Object)this.testRefPAttribute, (Object)this.testPFile.resolvePersistentAttribute("test.TestRefClass", "testField"));
        PersistenceFileReferenceTests.assertEquals((String)"Did not resolve \"test.TestClass.testField\" correctly", (Object)this.testPAttribute, (Object)this.testPFile.resolvePersistentAttribute("test.TestClass", "testField"));
    }
}

