/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.core.internal.ddl;

import java.util.Comparator;

import org.eclipse.wst.rdb.internal.models.sql.tables.Table;

public class TableComparator implements Comparator {

    public int compare(Object o1, Object o2) {
        if(o1 == o2){
            return 0;
        }
        if(o1 == null){
            return 1;
        }
        if(o2 == null){
            return -1;
        }
        if(!(o1 instanceof Table)){
            return 1;
        }
        if(!(o2 instanceof Table)){
            return -1;
        }
        String n1 =((Table)o1).getName();
        String n2 =((Table)o2).getName();
        if(n1 == n2){
            return 0;
        }
        if(n1 == null){
            return 1;
        }
        if(n2 == null){
            return -1;
        }
        return n1.compareTo(n2);
    }

}
