/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.core.internal.adaptors;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jsr220orm.core.internal.product.OrmProduct;
import org.eclipse.jsr220orm.core.internal.product.OrmProject;
import org.eclipse.jsr220orm.core.nature.OrmNature;

public class PersistenceProjectAdapterFactory implements IAdapterFactory {

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        IProject project;
        if(adaptableObject instanceof IJavaProject){
            project = ((IJavaProject)adaptableObject).getProject();
        }else if (adaptableObject instanceof IProject){
            project = (IProject) adaptableObject;
        }else{
            return null;
        }
        if(project == null){
            return null;
        }
        OrmNature nature = null;
        try {
            nature = (OrmNature) project.getNature(OrmNature.ID);
        } catch (CoreException e) {
            return null;
        }
        if(nature == null){
            return null;
        }
        if(OrmNature.class.equals(adapterType)){
            return nature;
        }
        OrmProject activeOrmProject = nature.getActiveOrmProject();
        if(activeOrmProject == null){
            return null;
        }
        if(OrmNature.class.equals(adapterType)){
            return nature;
        }
        OrmProduct product = activeOrmProject.getProduct();
        if(product == null){
            return null;
        }
        if(OrmProduct.class.equals(adapterType)){
            return product;
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[] {OrmNature.class, OrmProduct.class};
    }

}
