/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.core.internal.adaptors;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jsr220orm.core.nature.OrmNature;
import org.eclipse.ui.IActionFilter;

public class OrmNatureActionFilter implements IAdapterFactory, IActionFilter {

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        return this;
    }

    public Class[] getAdapterList() {
        return new Class[]{IActionFilter.class};
    }

    public boolean testAttribute(Object target, String name, String value) {
        if(target instanceof OrmNature){
            OrmNature nature = (OrmNature) target;
            if("activeOrmProduct".equals(name)){
                return value.equals(nature.getActiveOrmProject().getProduct().getId());
            }
        }
        return false;
    }

}
