/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.views.provider;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EStructuralFeatureTreeItem {
    
    private EObject object;
    private EStructuralFeature feature;

    public EStructuralFeatureTreeItem(EObject object, EStructuralFeature feature) {
        this.object = object;
        this.feature = feature;
    }

    public Collection getChildren() {
        EObject eObject = (EObject) object;
        if (feature.isMany()) {
            return (List) eObject.eGet(feature);
        } else {
            Object child = eObject.eGet(feature);
            if (child != null) {
                return Collections.singletonList(child);
            }else{
                return null;
            }
        }
    }

    public String toString() {
        return feature.getName();
    }
    
    
}
