/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.views;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jsr220orm.core.nature.OrmNature;
import org.eclipse.jsr220orm.metadata.MetadataElement;
import org.eclipse.jsr220orm.ui.OrmUiPlugin;
import org.eclipse.jsr220orm.ui.internal.mapping.AddPersistenceComposite;
import org.eclipse.jsr220orm.ui.internal.mapping.MainMetadataUISelector;
import org.eclipse.jsr220orm.ui.internal.mapping.NewEntityComposite;
import org.eclipse.jsr220orm.ui.mapping.MappingUIProvider;
import org.eclipse.jsr220orm.ui.mapping.MetadataUISelector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.PageBook;

public class MappingView extends AbstractMetadataView {
    
	public static final String ID_VIEW = "org.eclipse.jsr220orm.ui.internal.views.MappingView"; //$NON-NLS-1$
	
    private MetadataUISelector mappingUISelector;
    private NewEntityComposite newEntityComposite;
    private AddPersistenceComposite addPersistenceComposite;
	private PageBook book;
	private Control defaultPage;
    private FormToolkit toolkit;
    private boolean foundEntity;

	public Control getDefaultPage() {
		if (defaultPage == null) {
			defaultPage = createDefaultPage(book, toolkit);
		}
		return defaultPage;
	}

	protected Control createDefaultPage(PageBook book, FormToolkit toolkit) {
        FormText message = toolkit.createFormText(book, false);
        message.setText("No Mapping info to display.", false, false);
//		MessagePage page = new MessagePage();
//		page.createControl(book);
//		page.setMessage("No Mapping info to display.");
		return message;
	}

	protected void doUpdate(MetadataElement element) {
        MappingUIProvider provider = null;
		if (element != null) {
            provider = getMappingUISelector()
                    .getMappingUIProvider(element, book, toolkit);
        }
		if (provider == null) {
            unknownPartSelected();
		} else {
			book.showPage(provider.getControl(element, book, toolkit));
		}
	}

	public MetadataUISelector getMappingUISelector() {
		if (mappingUISelector == null) {
			mappingUISelector = createMappingUISelector();
		}
		return mappingUISelector;
	}

	private MetadataUISelector createMappingUISelector() {
		return new MainMetadataUISelector();
	}

	public void createPartControl(Composite parent) {
        toolkit = createToolkit(parent.getDisplay());
		book = new PageBook(parent, SWT.NONE);
	}

    protected FormToolkit createToolkit(Display display) {
        // Create a toolkit that shares colors between editors.
        return new FormToolkit(OrmUiPlugin.getDefault().getFormColors(display));
    }
    
	public void setFocus() {
		book.setFocus();
	}


    protected void unknownPartSelected() {
        try {
            IWorkingCopyManager manager = JavaUI.getWorkingCopyManager();
            IEditorPart activeEditor = getSite().getPage().getActiveEditor();
            if(activeEditor == null){
                book.showPage(getDefaultPage());
                return;
            }
            IEditorInput editorInput = activeEditor.getEditorInput();
            ICompilationUnit unit = manager.getWorkingCopy(editorInput);
            if (unit == null) {
                try {
                    manager.connect(editorInput);
                    unit = manager.getWorkingCopy(editorInput);
                    unknownUnitSelected(unit);
                    return;
                } catch (CoreException e1) {
                    book.showPage(getDefaultPage());
                    // well, nothing else to do here
                } finally {
                    manager.disconnect(editorInput);
                }
            } else {
                unknownUnitSelected(unit);
                return;
            }
        } catch (Exception e) {
            book.showPage(getDefaultPage());
            OrmUiPlugin.log(e);
        }
    }

    protected void unknownUnitSelected(ICompilationUnit unit) throws CoreException {
        if(unit == null){
            book.showPage(getDefaultPage());
            return;
        }
        IJavaProject javaProject = (IJavaProject) unit.getAncestor(IJavaElement.JAVA_PROJECT);
        IProject project = javaProject.getProject();
        OrmNature nature = (OrmNature) project.getNature(OrmNature.ID);
        if (nature != null) {
            NewEntityComposite newEntity = getNewEntityComposite(book, toolkit);
            newEntity.setCompilationUnit(unit);
            book.showPage(newEntity.getComposite());
        }else{
            AddPersistenceComposite addPersistenceComposite = getAddPersistenceComposite(book, toolkit);
            addPersistenceComposite.setIProject(project);
            book.showPage(addPersistenceComposite.getComposite());
        }
    }

    private NewEntityComposite getNewEntityComposite(PageBook book2, FormToolkit toolkit2) {
        if(newEntityComposite == null){
            newEntityComposite = new NewEntityComposite(this);
            newEntityComposite.createComposite(book2, SWT.NONE, toolkit2);
        }
        return newEntityComposite;
    }
    
    private AddPersistenceComposite getAddPersistenceComposite(PageBook book2, FormToolkit toolkit2) {
        if(addPersistenceComposite == null){
            addPersistenceComposite = new AddPersistenceComposite(this);
            addPersistenceComposite.createComposite(book2, SWT.NONE, toolkit2);
        }
        return addPersistenceComposite;
    }
}
