/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jsr220orm.ui.OrmUiPlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.PropertyPage;

/**
 * This page activates the Eclipse ORM plugin and the selected vendor plugins. A
 * Table with available vendors is displayed for selection
 */
public class OrmPropertyPage extends PropertyPage {

	private SelectProductComposite productComposite;

	public OrmPropertyPage() {
		super();
		setImageDescriptor(OrmUiPlugin.getImageDescriptor("icons/orm16.png"));
		setDescription("Please select which Persistence product(s) to use for this project.");
		setTitle("Select Persistence product");
	}

	/**
	 * @see PreferencePage#createContents(Composite)
	 */
	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
        IProject project = null;
		IAdaptable element = getElement();
        if(element instanceof IJavaProject){
            IJavaProject javaProject = (IJavaProject) element;
            project = javaProject.getProject();
            project = javaProject.getProject();
        }else if(element instanceof IProject){
            project = (IProject) element;
        }else if(element instanceof IAdaptable){
            project = (IProject) ((IAdaptable)element).getAdapter(IProject.class);
        }
		GridLayout composite1Layout = new GridLayout();
		composite.setLayout(composite1Layout);
		productComposite = new SelectProductComposite(composite, false);
		try {
            productComposite.setProject(project);
        } catch (Exception e) {
            OrmUiPlugin.logException(e, "Problem loading presistence settings.", getShell());
        }
		GridData productTableLData = new GridData();
		productTableLData.grabExcessHorizontalSpace = true;
		productTableLData.grabExcessVerticalSpace = true;
		productTableLData.horizontalAlignment = GridData.FILL;
		productTableLData.verticalAlignment = GridData.FILL;
		productComposite.setLayoutData(productTableLData);
		if (!productComposite.hasProducts()) {
			setMessage("No Persistence products found.");
		}
		return composite;
	}

	protected void performDefaults() {
		productComposite.clearSelection();
	}

	public boolean performOk() {
	    return productComposite.setProductOnProject();
	}
}