/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.mapping;

import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.MetadataElement;
import org.eclipse.jsr220orm.ui.mapping.MappingUIProvider;
import org.eclipse.jsr220orm.ui.mapping.MetadataUISelector;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MessagePage;

public class DefaultMetadataUISelector implements MetadataUISelector {

	private MappingUIProvider defaultPage;

	private MappingUIProvider attributePage;

	private MappingUIProvider entityPage;

	public DefaultMetadataUISelector() {
	}

	public MappingUIProvider getMappingUIProvider(MetadataElement element,
			Composite parent, FormToolkit toolkit) {
		MetadataElement attribute = element
				.getAncestor(AttributeMetaData.class);
		if (attribute instanceof AttributeMetaData) {
			return getAttributePage(parent);
		} else {
			MetadataElement entity = element.getAncestor(EntityMetaData.class);
			if (entity != null) {
				return getEntityPage(parent);
			}
		}
		return getDefaultPage(parent);
	}

	private MappingUIProvider getAttributePage(Composite parent) {
		if (attributePage == null) {
			attributePage = new AttributeMappingUIProvider();
		}
		return attributePage;
	}

	private MappingUIProvider getEntityPage(Composite parent) {
		if (entityPage == null) {
			entityPage = new EntityMappingUIProvider();
		}
		return entityPage;
	}

	private MappingUIProvider getDefaultPage(Composite parent) {
		if (defaultPage == null) {
			defaultPage = new DefaultMappingUIProvider();
		}
		return defaultPage;
	}

	private class DefaultMappingUIProvider implements MappingUIProvider {

		private IPage defaultPage;

		public Control getControl(MetadataElement element, Composite parent, 
                FormToolkit toolkit) {
			if (defaultPage == null) {
				defaultPage = createDefaultPage(parent);
			}
			return defaultPage.getControl();
		}

		private IPage createDefaultPage(Composite parent) {
			MessagePage page = new MessagePage();
			page.createControl(parent);
			page.setMessage("No Mapping info to display.");
			return page;
		}

	}
}
