/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.mapping;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.metadata.BasicAttribute;
import org.eclipse.jsr220orm.metadata.CollectionAttribute;
import org.eclipse.jsr220orm.metadata.EmbeddedAttribute;
import org.eclipse.jsr220orm.metadata.ReferenceAttribute;
import org.eclipse.jsr220orm.metadata.provider.MetadataItemProviderAdapterFactory;
import org.eclipse.jsr220orm.ui.internal.mapping.composite.AttributeComposite;
import org.eclipse.jsr220orm.ui.internal.mapping.composite.AttributeMappingGroup;
import org.eclipse.jsr220orm.ui.internal.mapping.composite.BasicAttributeComposite;
import org.eclipse.jsr220orm.ui.internal.mapping.composite.CollectionAttributeComposite;
import org.eclipse.jsr220orm.ui.internal.mapping.composite.EmbeddedAttributeComposite;
import org.eclipse.jsr220orm.ui.internal.mapping.composite.ReferenceAttributeComposite;
import org.eclipse.jsr220orm.ui.internal.views.provider.OutlineLabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.PageBook;

public class AttributeBook {

    private Form mainForm;
    private Form blankPage;
    private Section section;
    private AttributeMetaData attributeMetaData;
    private AttributeMappingGroup mappingGroup = new AttributeMappingGroup(this);
    private PageBook attributeBook;
    private FormToolkit toolkit;
    private ComposedAdapterFactory adapterFactory;
    private OutlineLabelProvider labelProvider;
    private AttributeComposite defaultPage;
    private BasicAttributeComposite basicAttributeComposite;
    private ReferenceAttributeComposite referenceAttributeComposite;
    private CollectionAttributeComposite collectionAttributeComposite;
    private EmbeddedAttributeComposite embeddedAttributeComposite;
    
    public AttributeBook() {
        List factories = new ArrayList();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new MetadataItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        adapterFactory = new ComposedAdapterFactory(factories);
        labelProvider = new OutlineLabelProvider(adapterFactory);
    }

    public void createPartControl(Composite parent, FormToolkit toolkit) {
        this.toolkit = toolkit;
        mainForm = toolkit.createForm(parent);
        mainForm.setLayoutData(new GridData(GridData.FILL_HORIZONTAL|GridData.FILL_VERTICAL));
        mainForm.getBody().setLayout(new GridLayout());
        section = toolkit.createSection(mainForm.getBody(), ExpandableComposite.TITLE_BAR);
        section.setLayoutData(new GridData(GridData.FILL_HORIZONTAL|GridData.FILL_VERTICAL));
        Form form = toolkit.createForm(section);
        form.setLayoutData(new GridData(GridData.FILL_HORIZONTAL|GridData.FILL_VERTICAL));
        section.setClient(form);
        GridLayout thisLayout = new GridLayout();
        form.getBody().setLayout(thisLayout);
        mappingGroup.createControl(form.getBody(), toolkit);
        GridData mappingGroupLData = new GridData();
        mappingGroupLData.grabExcessHorizontalSpace = true;
        mappingGroupLData.horizontalAlignment = GridData.FILL;
        mappingGroup.getComposite().setLayoutData(mappingGroupLData);
        attributeBook = new PageBook(form.getBody(), SWT.NONE);
        attributeBook.setLayoutData(new GridData(GridData.FILL_HORIZONTAL|GridData.FILL_VERTICAL));
        form.getBody().layout();
    }

    public AttributeMetaData getAttributeMetaData() {
        return attributeMetaData;
    }

    public void setAttributeMetaData(AttributeMetaData attributeMetaData) {
        this.attributeMetaData = attributeMetaData;
//        title.setImage(labelProvider.getImage(attributeMetaData));
        section.setText(labelProvider.getText(attributeMetaData));
        mappingGroup.setMetaDataElement(attributeMetaData);
        attributeBook.showPage(getAttributeTab(attributeMetaData));
        section.layout();
    }

    protected Control getAttributeTab(AttributeMetaData attributeMetaData) {
        // TODO turn into extention point
        if(attributeMetaData.isNonPersistent()){
            return getBlankPage();
        }else if (attributeMetaData instanceof BasicAttribute) {
            return getBasicAttributeComposite(attributeMetaData);
        } else if (attributeMetaData instanceof ReferenceAttribute) {
            return getReferenceAttributeComposite(attributeMetaData);
        } else if (attributeMetaData instanceof CollectionAttribute) {
            return getCollectionAttributeComposite(attributeMetaData);
        }else if (attributeMetaData instanceof EmbeddedAttribute) {
            return getEmbeddedAttributeComposite(attributeMetaData);
        }
        return getDefaultPage(attributeMetaData);
    }

    private Control getBlankPage() {
        if(blankPage == null){
            blankPage = toolkit.createForm(attributeBook);
        }
        return blankPage;
    }

    private Control getBasicAttributeComposite(
            AttributeMetaData attributeMetaData) {
        if (basicAttributeComposite == null) {
            basicAttributeComposite = new BasicAttributeComposite();
            basicAttributeComposite.createComposite(attributeBook, toolkit,
                    adapterFactory);
        }
        basicAttributeComposite.setAttributeMetaData(attributeMetaData);
        return basicAttributeComposite.getComposite();
    }

    private Control getReferenceAttributeComposite(
            AttributeMetaData attributeMetaData) {
        if (referenceAttributeComposite == null) {
            referenceAttributeComposite = new ReferenceAttributeComposite();
            referenceAttributeComposite.createComposite(attributeBook, toolkit,
                    adapterFactory);
        }
        referenceAttributeComposite.setAttributeMetaData(attributeMetaData);
        return referenceAttributeComposite.getComposite();
    }

    private Control getCollectionAttributeComposite(
            AttributeMetaData attributeMetaData) {
        if (collectionAttributeComposite == null) {
            collectionAttributeComposite = new CollectionAttributeComposite();
            collectionAttributeComposite.createComposite(attributeBook,
                    toolkit, adapterFactory);
        }
        collectionAttributeComposite.setAttributeMetaData(attributeMetaData);
        return collectionAttributeComposite.getComposite();
    }
    
    private Control getEmbeddedAttributeComposite(
            AttributeMetaData attributeMetaData) {
        if (embeddedAttributeComposite == null) {
            embeddedAttributeComposite = new EmbeddedAttributeComposite();
            embeddedAttributeComposite.createComposite(attributeBook,
                    toolkit, adapterFactory);
        }
        embeddedAttributeComposite.setAttributeMetaData(attributeMetaData);
        return embeddedAttributeComposite.getComposite();
    }

    protected Control getDefaultPage(AttributeMetaData attributeMetaData) {
        if (defaultPage == null) {
            defaultPage = createDefaultPage();
        }
        defaultPage.setAttributeMetaData(attributeMetaData);
        return defaultPage.getComposite();
    }

    protected AttributeComposite createDefaultPage() {
        AttributeComposite attributeComposite = new AttributeComposite();
        attributeComposite.createComposite(attributeBook, toolkit,
                adapterFactory);
        return attributeComposite;
    }

    public Control getControl() {
        return mainForm;
    }

}
