/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

/*
 * Created on Mar 22, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.eclipse.jsr220orm.ui.internal.diagram.er.part;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.metadata.OrmTable;
import org.eclipse.jsr220orm.ui.OrmUiPlugin;
import org.eclipse.jsr220orm.ui.internal.diagram.EditableLabel;
import org.eclipse.jsr220orm.ui.internal.diagram.er.IHelpTextHelper;
import org.eclipse.jsr220orm.ui.internal.diagram.er.edit.ExtendedDirectEditManager;
import org.eclipse.jsr220orm.ui.internal.diagram.er.edit.LabelCellEditorLocator;
import org.eclipse.jsr220orm.ui.internal.diagram.er.edit.TableDirectEditPolicy;
import org.eclipse.jsr220orm.ui.internal.diagram.er.figure.TableFigure;
import org.eclipse.jsr220orm.ui.internal.diagram.er.model.DotDotDotColumn;
import org.eclipse.jsr220orm.ui.internal.diagram.er.model.TableSectionHeader;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;

/**
 * @author dirk
 */
public class TableEditPart extends MetadataEditPart {

    private Set colSet;
    private OrmTable table;
    private Schema schema;
    protected DirectEditManager manager;
    private Table rdbTable;
    private Map rdbCols = new HashMap();
    private Map ormCols = new HashMap();
    private List children = new ArrayList(); 
    private boolean connected;
    private IHelpTextHelper helper;

    public TableEditPart(Schema schema, Set colSet, OrmTable table, IHelpTextHelper helper) {
        this.colSet = colSet;
        this.schema = schema;
        this.table = table;
        this.helper = helper;
        connected = schema != null;
        selectColumns();
        setModel(table);
    }

    public void selectColumns() {
        ormCols.clear();
        children.clear();
        children.addAll(table.getColumnList());
        DotDotDotColumn lastDotDotDot = null;
        for (int x = 0; x < children.size(); x++) {
            OrmColumn ormColumn = (OrmColumn) children.get(x);
            String name = ormColumn.getName();
            if (name == null) {
            	name ="<NULL" + x + ">";
            }
            ormCols.put(name.toLowerCase(), ormColumn);
            if (!colSet.contains(ormColumn)) {
                children.remove(x);
                if(lastDotDotDot == null){
                    lastDotDotDot = new DotDotDotColumn();
                    children.add(x, lastDotDotDot);
                }else{
                    x--;
                }
                lastDotDotDot.add(ormColumn);
            }else{
                lastDotDotDot = null;
            }
        }
        String tableName = table.getName();
        rdbCols.clear();
        if (tableName != null && connected) {
            try {
                EList tables = schema.getTables();
                connected = !tables.isEmpty();
                for (Iterator it = tables.iterator(); it.hasNext();) {
                    Table rdbTable = (Table) it.next();
                    if (rdbTable.getName().equalsIgnoreCase(tableName)) {
                        boolean foundRdbCols = false;
                        this.rdbTable = rdbTable;
                        EList columns = rdbTable.getColumns();
                        for (Iterator cols = columns.iterator(); cols.hasNext();) {
                            Column rdbColumn = (Column) cols.next();
                            String name = rdbColumn.getName().toLowerCase();
                            rdbCols.put(name, rdbColumn);
                            if (!ormCols.containsKey(name)) {
                                if(!foundRdbCols){
                                    foundRdbCols = true;
//                                    helper.addHelpText("<b>Unmapped columns</b> are in the database table and not mapped in the class.");
                                    helper.addHelpText("<b>Drag and drop</b> unmapped columns onto mapped columns to map them.");
                                    children.add(new TableSectionHeader("Unmapped columns"));
                                }
                                children.add(rdbColumn);
                            }
                        }
                        break;
                    }
                }
            } catch (Throwable e) {
                connected = false;
                OrmUiPlugin.log(new Status(IStatus.WARNING, OrmUiPlugin.getPluginId(), IStatus.OK, "Could not load table data.", e));
            }
        }
        if(!connected){
            helper.addHelpText("Connect to database using Persistence Properties to map to existing columns");
        }
        if(rdbCols != null && !rdbCols.isEmpty()){
            for (int x = 0; x < children.size(); x++) {
                Object object = children.get(x);
                if (object instanceof OrmColumn) {
                    OrmColumn ormColumn = (OrmColumn) object;
                    String name = ormColumn.getName().toLowerCase();
                    if(!rdbCols.containsKey(name)){
                        helper.addHelpText("<span color=\"red\">Red Columns</span> where <b>not</b> found in the database table.");
                        break;
                    }
                }
            }
        }
    }

    protected IFigure createFigure() {
        return new TableFigure();
    }

    protected void createEditPolicies() {
        installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE,
                new TableDirectEditPolicy());
//        installEditPolicy(EditPolicy.LAYOUT_ROLE, new TableLayoutEditPolicy());
    }

    protected void refreshVisuals() {
        OrmTable node = (OrmTable) getModel();
        TableFigure table = (TableFigure) getFigure();
        table.setName(node.getName());
        table.setToolTipText(node.getComment());

        // createConnection()
    }

    protected List getModelChildren() {
        try{
        selectColumns();
        }catch(Throwable s){
            s.printStackTrace();
        }
        return children;
    }

    public IFigure getContentPane() {
        TableFigure figure = (TableFigure) getFigure();
        return figure.getContentPane();
    }

    /**
     * @see org.eclipse.gef.EditPart#getDragTracker(Request)
     */
    public DragTracker getDragTracker(Request req) {
        return new SelectEditPartTracker(this);
    }

    public void setSelected(int value)
    {
        super.setSelected(value);
        TableFigure figure = (TableFigure) getFigure();
        if (value != EditPart.SELECTED_NONE)
            figure.setSelected(true);
        else
            figure.setSelected(false);
    }

    // ******************* Direct editing related methods *********************/

    /**
     * @see org.eclipse.gef.EditPart#performRequest(org.eclipse.gef.Request)
     */
    public void performRequest(Request request) {
        if (request.getType() == RequestConstants.REQ_DIRECT_EDIT) {
            if (request instanceof DirectEditRequest
                    && !directEditHitTest(((DirectEditRequest) request)
                            .getLocation().getCopy()))
                return;
            performDirectEdit();
        }
    }

    private boolean directEditHitTest(Point requestLoc) {
        // TableFigure figure = (TableFigure) getFigure();
        // EditableLabel nameLabel = figure.getNameLabel();
        // nameLabel.translateToRelative(requestLoc);
        // if (nameLabel.containsPoint(requestLoc))
        // return true;
        return true;
    }

    protected void performDirectEdit() {
        {
            if (manager == null)
            {
                TableFigure figure = (TableFigure) getFigure();
                EditableLabel nameLabel = figure.getNameLabel();
                manager = new ExtendedDirectEditManager(this, TextCellEditor.class, new LabelCellEditorLocator(nameLabel),
                        nameLabel, null);
            }
            manager.show();
        }
    }

    /**
     * @param handles
     *            the name change during an edit
     */
    public void handleNameChange(String value) {
        TableFigure tableFigure = (TableFigure) getFigure();
        tableFigure.setNameVisible(false);
        refreshVisuals();
    }

    /**
     * Reverts to existing name in model when exiting from a direct edit
     * (possibly before a commit which will result in a change in the label
     * value)
     */
    public void revertNameChange() {
        TableFigure tableFigure = (TableFigure) getFigure();
        tableFigure.setNameVisible(true);
        refreshVisuals();
    }

    public Map getOrmCols() {
        return ormCols;
    }

    public Map getRdbCols() {
        return rdbCols;
    }

    public boolean isConnected() {
        return connected;
    }

    public void expandDots() {
        ArrayList refreshList = new ArrayList(4);
        for(Iterator it = children.iterator(); it.hasNext();){
            Object col = it.next();
            if (col instanceof DotDotDotColumn) {
                DotDotDotColumn ddd = (DotDotDotColumn) col;
                List hiddenColumns = ddd.getHiddenColumns();
                colSet.addAll(hiddenColumns);
                refreshList.addAll(hiddenColumns);
            }
        }
        ArrayList children = new ArrayList();
        EditPart parent = getParent();
        if (parent != null) {
            children.addAll(parent.getChildren());
        }else{
            children.addAll(getChildren());
        }
        for (int x=0; x < children.size(); x++) {
            AbstractEditPart child = (AbstractEditPart) children.get(x);
            children.addAll(child.getChildren());
            child.refresh();
        }
    }
}
