/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.diagram.er.part;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public abstract class MetadataEditPart extends AbstractGraphicalEditPart implements Adapter{

    private Class modelClass;

    public void setModel(Object model) {
        super.setModel(model);
        modelClass = model.getClass();
    }

    public void activate() {
        super.activate();
        Object model = getModel();
        if (model != null && model instanceof EObject) {
            ((EObject)model).eAdapters().add(this);
        }
    }

    public void deactivate() {
        super.deactivate();
        Object model = getModel();
        if (model != null && model instanceof EObject) {
            ((EObject)model).eAdapters().remove(this);
        }
    }

    public Notifier getTarget() {
        return null;
    }

    public boolean isAdapterForType(Object type) {
        return modelClass != null && modelClass.equals(type);
    }

    public void notifyChanged(Notification notification) {
        int eventType = notification.getEventType();
        if(eventType == Notification.REMOVING_ADAPTER ||
                eventType == Notification.REMOVE){
            return;
        }
        refresh();
    }

    public void setTarget(Notifier newTarget) {
    }

}
