/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.diagram.er.figure;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.jsr220orm.ui.OrmUiPlugin;
import org.eclipse.jsr220orm.ui.internal.diagram.EditableLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

/**
 * @author dirk
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ColumnFigure extends Figure {

	private static final Image pkImage = OrmUiPlugin.getImageDescriptor("icons/ER_PrimaryKey.png").createImage();
	private static final Image emptyImage = OrmUiPlugin.getImageDescriptor("icons/empty16.png").createImage();
    private EditableLabel nameLabel = new EditableLabel();
    private Label typeFigure = new Label();
    private Map rdbCols = new HashMap();
    private Map ormCols = new HashMap();
    private boolean selected;
    private boolean connected;
    
    public ColumnFigure(Map ormCols, Map rdbCols, boolean connected) {
        super();
        this.ormCols = ormCols;
        this.rdbCols = rdbCols;
        this.connected = connected;
        nameLabel.setIconTextGap(1);
		BorderLayout layout = new BorderLayout();
		layout.setHorizontalSpacing(8);
	    setLayoutManager(layout);	
	    add(nameLabel, BorderLayout.LEFT);	
	    add(typeFigure, BorderLayout.RIGHT);
        setBackgroundColor(ColorConstants.menuBackgroundSelected);
        setOpaque(false);
        setBorder(EmptyBorder.INSTANCE);
        nameLabel.setIcon(emptyImage);
	}
      
    public void setPrimaryKey(boolean pk){
        nameLabel.setIcon(pk ? pkImage : emptyImage);
    }
      
    public void setName(String name){
        nameLabel.setText(name);
        typeFigure.setForegroundColor(getForegroundColor());
    }
	  
	public void setType(String type){
        typeFigure.setText(type);
        typeFigure.setForegroundColor(getForegroundColor());
	}

    public void setSelected(boolean selected) {
        this.selected = selected;
        setOpaque(selected);
        typeFigure.setForegroundColor(getForegroundColor());
//        super.setForegroundColor(selected ? ColorConstants.menuForegroundSelected : realForegroundColor);
    }

    public void setToolTipText(String toolTipText){
        if(toolTipText == null || toolTipText.trim().length() == 0){
            setToolTip(null);
        }else{
            Label label = new Label(toolTipText);
            label.setBackgroundColor(ColorConstants.tooltipBackground);
            label.setForegroundColor(ColorConstants.tooltipForeground);
            setToolTip(label);
        }
    }
    
    /**
     * paints figure differently depends on the whether the figure has focus or
     * is selected
     */
    protected void paintFigure(Graphics graphics) {
        if (selected) {
            graphics.setBackgroundColor(ColorConstants.menuBackgroundSelected);
        }
        graphics.setForegroundColor(getForegroundColor());
        super.paintFigure(graphics);
    }

    protected void paintChildren(Graphics graphics) {
        graphics.setForegroundColor(getForegroundColor());
        super.paintChildren(graphics);
    }

    public Color getForegroundColor(){
        if (selected) {
            return ColorConstants.menuForegroundSelected;
        }
        if(!connected){
            return ColorConstants.black;
        }
        String name = nameLabel.getText().toLowerCase();
        boolean orm = ormCols.containsKey(name);
        boolean rdb = rdbCols.containsKey(name);
        if(orm){
            if(rdb){
                return ColorConstants.black;
            }else{
                return ColorConstants.red;
            }
        }else{
            if(rdb){
                return ColorConstants.black;
            }else{
                return ColorConstants.gray;
            }
        }
    }
}
